/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.impl.memory;

import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.ISonicPotentialEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicPotentialEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicUtils;
import com.sonicmetrics.core.shared.util.JsonUtils;
import java.io.Serializable;
import java.util.Map;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;

public class SonicEvent
extends SonicPotentialEvent
implements ISonicEvent,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(SonicEvent.class);
    private static final long MS_PER_MINUTE = 60000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long serialVersionUID = 1L;
    protected String key;
    protected long timestamp;

    public static SeBuilder create(long utcTimestamp) {
        return new SeBuilder(utcTimestamp);
    }

    public static SeBuilder createFrom(ISonicEvent se) {
        SeBuilder b = SonicEvent.create(se.getWhen());
        b.category(se.getCategory());
        b.action(se.getAction());
        b.source(se.getSource());
        b.subject(se.getSubject());
        b.labelIgnoreIfNull(se.getLabel());
        b.valueIgnoreIfNull(se.getValue());
        if (se.getUniqueId() != null) {
            b.uniqueId(se.getUniqueId());
        }
        b.withParams(se.getExtensionData());
        return b;
    }

    public static String toDebugTime(long utcTimestamp) {
        long days = utcTimestamp / 86400000L;
        long millis = utcTimestamp % 86400000L;
        long minutes = millis / 60000L;
        long remainingMillis = millis % 60000L;
        return days + "d|" + minutes + "m|" + remainingMillis + "ms";
    }

    public SonicEvent() {
    }

    private SonicEvent(long utcTimestamp) {
        this.timestamp = utcTimestamp;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ISonicEvent)) {
            return false;
        }
        ISonicEvent o = (ISonicEvent)other;
        if (this.getWhen() != o.getWhen()) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getKey(), o.getKey())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getUniqueId(), o.getUniqueId())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getSubject(), o.getSubject())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getCategory(), o.getCategory())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getAction(), o.getAction())) {
            return false;
        }
        if (!SonicUtils.bothNullOrEqual(this.getLabel(), o.getLabel())) {
            return false;
        }
        return SonicUtils.bothNullOrEqual(this.getSource(), o.getSource());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getWhen() {
        return this.timestamp;
    }

    public int hashCode() {
        return (int)(this.timestamp % Integer.MAX_VALUE) + (this.key == null ? 0 : this.key.hashCode());
    }

    @Override
    public void setKey(String key) {
        XyAssert.validateCondition((this.key == null ? 1 : 0) != 0, (String)"Key can be set only once");
        this.key = key;
    }

    @Override
    public StringBuilder toJsonObject() {
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        JsonUtils.appendKeyValue(b, "when", this.getWhen());
        b.append(", ");
        JsonUtils.appendKeyValue(b, "subject", this.getSubject());
        b.append(", ");
        JsonUtils.appendKeyValue(b, "category", this.getCategory());
        b.append(", ");
        JsonUtils.appendKeyValue(b, "action", this.getAction());
        if (this.hasLabel()) {
            b.append(", ");
            b.append((CharSequence)JsonUtils.string("label")).append(":").append((CharSequence)JsonUtils.string(this.getLabel()));
        }
        b.append(", ");
        JsonUtils.appendKeyValue(b, "source", this.getSource());
        if (this.getKey() != null) {
            b.append(", ");
            JsonUtils.appendKeyValue(b, "key", this.getKey());
        }
        if (this.hasUniqueId()) {
            b.append(", ");
            JsonUtils.appendKeyValue(b, "uniqueid", this.getUniqueId());
        }
        for (Map.Entry entry : this.extensionDataMap.entrySet()) {
            b.append(", ");
            JsonUtils.appendKeyValue(b, (String)entry.getKey(), (String)entry.getValue());
        }
        b.append(" ");
        b.append("}");
        return b;
    }

    @Override
    public String toString() {
        return this.timestamp + "utc=(" + SonicEvent.toDebugTime(this.timestamp) + ") " + super.toString();
    }

    public Map<String, String> getModifyableExtensionData() {
        return this.extensionDataMap;
    }

    @Override
    public int compareTo(ISonicEvent o) {
        if (this.getWhen() < o.getWhen()) {
            return -1;
        }
        if (this.getWhen() > o.getWhen()) {
            return 1;
        }
        int c = SonicEvent.compare(this.getKey(), o.getKey());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getUniqueId(), o.getUniqueId());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getSubject(), o.getSubject());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getCategory(), o.getCategory());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getAction(), o.getAction());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getLabel(), o.getLabel());
        if (c != 0) {
            return c;
        }
        c = SonicEvent.compare(this.getSource(), o.getSource());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    private static int compare(String t, String o) {
        if (t == null) {
            if (o == null) {
                return 0;
            }
            return 1;
        }
        if (o == null) {
            return -1;
        }
        return t.compareTo(o);
    }

    @Override
    public final int size() {
        int size = 39 + super.size();
        for (Map.Entry e : this.extensionDataMap.entrySet()) {
            size += this.size((String)e.getKey()) + this.size((String)e.getValue());
        }
        return size += this.size(this.key);
    }

    public static class SeBuilder
    extends SonicPotentialEvent.Builder<SonicEvent, SeBuilder> {
        public SeBuilder(long utcTimestamp) {
            this.t = new SonicEvent(utcTimestamp);
            this.b = this;
        }

        @Override
        public void validate() {
            XyAssert.validateNotNull((Object)((SonicEvent)this.t).category, (String)"category");
            XyAssert.validateNotNull((Object)((SonicEvent)this.t).action, (String)"action");
            XyAssert.validateNotNull((Object)((SonicEvent)this.t).subject, (String)"subject");
            XyAssert.validateNotNull((Object)((SonicEvent)this.t).source, (String)"source");
        }

        public SeBuilder withParams(Map<String, String> map) throws IllegalArgumentException {
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                boolean recognized = false;
                for (ISonicPotentialEvent.FilterProperty ip : ISonicPotentialEvent.FilterProperty.values()) {
                    if (!ip.name().toLowerCase().equals(key.toLowerCase())) continue;
                    recognized = true;
                    this.withParam(ip, value);
                    break;
                }
                if (recognized) continue;
                this.withParam(key, value);
            }
            return this;
        }

        public String getExtensionDataValue(String key) {
            return ((SonicEvent)this.t).getExtensionData().get(key);
        }
    }
}

