/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.core.shared.impl.memory;

import com.sonicmetrics.core.shared.ISonicDB;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicQueryResult;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.ISonicQueryResult;
import com.sonicmetrics.core.shared.query.SonicMetadataResult;
import com.sonicmetrics.core.shared.query.TimeConstraint;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xydra.base.id.UUID;
import org.xydra.index.query.Pair;

public class SonicMemoryDB
implements ISonicDB {
    public static final String LAST_UNICODE_CHAR = "\uffff";
    private SortedMap<String, ISonicEvent> db = new TreeMap<String, ISonicEvent>();

    @Override
    public void receiveEvent(ISonicEvent sonicEvent) {
        String key = sonicEvent.getKey();
        if (key == null) {
            key = SonicMemoryDB.toKey(sonicEvent.getWhen()) + "-" + UUID.uuid((int)8);
        }
        sonicEvent.setKey(key);
        this.db.put(key, sonicEvent);
    }

    static Pair<String, String> toKeyConstraint(TimeConstraint timeConstraint, long now) {
        String lastKey;
        long endTime = timeConstraint.end;
        if (endTime == 0L) {
            endTime = now;
        }
        if ((lastKey = timeConstraint.lastKey) == null) {
            assert (timeConstraint.start >= 0L) : timeConstraint.start;
            long startInclusive = timeConstraint.start;
            lastKey = startInclusive + "";
        }
        return new Pair((Object)lastKey, (Object)(SonicMemoryDB.toKey(endTime) + LAST_UNICODE_CHAR));
    }

    private static String toKey(long now) {
        return now + "";
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void setKey(ISonicEvent sonicEvent) {
    }

    @Override
    public SonicMetadataResult search(String keyword) {
        return null;
    }

    @Override
    public ISonicQueryResult query(ISonicQuery sonicQuery) {
        long now = this.getCurrentTime();
        Pair<String, String> keyConstraint = SonicMemoryDB.toKeyConstraint(sonicQuery.getTimeConstraint(), now);
        Iterator<ISonicEvent> it = this.db.subMap((String)keyConstraint.getFirst(), (String)keyConstraint.getSecond()).values().iterator();
        return new SonicQueryResult(it);
    }

    @Override
    public void delete(ISonicQuery sonicQuery) {
    }

    @Override
    public void receiveEventAsync(ISonicEvent sonicEvent) {
    }
}

