/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io;

import com.calpano.kgif.io.IFileFormat;
import java.util.Arrays;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FileFormat
implements IFileFormat,
Comparable<FileFormat> {
    private static final Logger log = LoggerFactory.getLogger(FileFormat.class);
    private final String contentType;
    private final String defaultName;
    private final String[] extensions;
    private final String formatLabel;
    private final String formatName;
    private final String help;
    private final double q;
    private final String syntaxLabel;

    public FileFormat(String formatName, String formatLabel, String syntaxLabel, String defaultName, String[] extensions, String contentType, double q, String help) {
        assert (formatName != null);
        this.formatName = formatName;
        this.formatLabel = formatLabel;
        this.syntaxLabel = syntaxLabel;
        this.defaultName = defaultName;
        for (String ext : this.extensions = extensions == null ? new String[]{} : extensions) {
            assert (!ext.startsWith(".")) : "file extension in FileFormat may not start with dot ('.')";
        }
        this.contentType = contentType;
        this.q = q;
        this.help = help;
    }

    @Override
    public int compareTo(FileFormat o) {
        double delta = o.q - this.q;
        int i = (int)Math.signum(delta);
        if (i != 0) {
            return i;
        }
        i = this.formatLabel.compareTo(o.formatLabel);
        if (i != 0) {
            return i;
        }
        if (this.syntaxLabel != null && o.syntaxLabel != null) {
            return this.syntaxLabel.compareTo(o.syntaxLabel);
        }
        log.warn("Could not decide which fileFormat is better: " + this + " OR " + o);
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof IFileFormat) {
            IFileFormat of = (IFileFormat)o;
            return this.getFormatName().equals(of.getFormatName());
        }
        return false;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public String getDefaultExtension() {
        assert (this.extensions != null);
        if (this.extensions.length < 1) {
            return null;
        }
        return this.extensions[0];
    }

    public String getDefaultFileName() {
        return this.defaultName;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public String[] getExtensions() {
        return this.extensions == null ? new String[]{} : this.extensions;
    }

    @Override
    public String getFormatLabel() {
        return this.formatLabel;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public String getHelp() {
        return this.help;
    }

    @Override
    public String getSyntaxLabel() {
        return this.syntaxLabel;
    }

    public int hashCode() {
        return this.formatName.hashCode();
    }

    public String toString() {
        return this.formatName + " (" + this.getFormatLabel() + "/" + this.getSyntaxLabel() + " = " + this.contentType + ")" + " Ext:" + Arrays.toString(this.extensions) + " -- " + this.help;
    }
}

