/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_1.write;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.util.HumanReadableText;
import com.calpano.kgif.v1_0_1.IEntityHandler;
import com.calpano.kgif.v1_0_1.gen.Header;
import com.calpano.kgif.v1_0_1.gen.Kgif;
import com.calpano.kgif.v1_0_1.gen.Link;
import com.calpano.kgif.v1_0_1.gen.Metadata;
import com.calpano.kgif.v1_0_1.gen.Node;
import com.calpano.kgif.v1_0_1.gen.Property;
import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WritingEntityHandler
implements IEntityHandler {
    private final AttributesImpl emptyXmlAttributes = new AttributesImpl();
    private final Marshaller marshaller;
    private final Writer writer;
    private final XMLWriter xw;

    public WritingEntityHandler(Writer writer) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kgif.class});
        this.marshaller = context.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.marshaller.setProperty("jaxb.fragment", (Object)true);
        this.marshaller.setProperty("jaxb.encoding", (Object)"Unicode");
        this.writer = writer;
        this.xw = new XMLWriter(this.writer);
    }

    @Override
    public void close() throws IOException {
        this.xw.close();
    }

    @Override
    public void onDocumentEnd(IIoContext ioContext) throws IOException {
        this.writer.write("\n");
        try {
            this.xw.endElement(null, null, "kgif");
            this.xw.endDocument();
            this.writer.flush();
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void onDocumentStart(IIoContext ioContext) throws IOException {
        try {
            this.xw.startDocument();
            this.xw.startDTD("kgif", "http://xam.de/ns/kgif/v1.0.0/kgif_v1_0_1.dtd", "http://xam.de/ns/kgif/v1.0.0/kgif_v1_0_1.dtd");
            this.writer.write("\n");
            this.xw.startElement(null, null, "kgif", (Attributes)this.emptyXmlAttributes);
            this.writer.write("\n");
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void onGraphEnd(IIoContext ioContext) throws IOException {
        this.writer.write("\n");
        try {
            this.xw.endElement(null, null, "graph");
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void onGraphStart(IIoContext ioContext, Metadata metadata) throws IOException {
        try {
            this.xw.startElement(null, null, "graph", (Attributes)this.emptyXmlAttributes);
            if (metadata != null) {
                this.write(metadata);
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void onHeader(IIoContext ioContext, Header header) throws IOException {
        header.setFileLastModified(HumanReadableText.fullDateTimeIso(System.currentTimeMillis()));
        this.write(header);
    }

    @Override
    public void onLink(IIoContext ioContext, Link link) throws IOException {
        this.writer.write("\n");
        this.write(link);
    }

    @Override
    public void onNode(IIoContext ioContext, Node node) throws IOException {
        this.writer.write("\n");
        this.write(node);
    }

    @Override
    public void onProperty(IIoContext ioContext, Property property) throws IOException {
        this.writer.write("\n");
        this.write(property);
    }

    public void write(Object kgifObject) throws IOException {
        try {
            this.marshaller.marshal(kgifObject, this.writer);
        }
        catch (JAXBException e) {
            throw new IOException("Error", e);
        }
    }
}

