/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_1_0.read;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.KgifMeta;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Footer;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReader;
import java.io.IOException;
import java.io.Reader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifMetadataReader {
    private static final Logger log = LoggerFactory.getLogger(KgifMetadataReader.class);

    public static KgifMeta readKgifMeta(Reader r) throws KgifReadWriteException, IOException {
        MyEntityHandler eh = new MyEntityHandler();
        try (KgifReader kr = new KgifReader(r, eh);){
            kr.read();
        }
        catch (Exception e) {
            log.trace("Exception", (Throwable)e);
        }
        if (eh.schemaVersionDate == null && eh.schemaVersionNumber == null) {
            return null;
        }
        return new KgifMeta(eh.schemaVersionNumber, eh.schemaVersionDate);
    }

    private static class MyEntityHandler
    implements IEntityHandler {
        String schemaVersionNumber = null;
        String schemaVersionDate = null;

        private MyEntityHandler() {
        }

        @Override
        public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onNode(IIoContext ioContext, Node node) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onLink(IIoContext ioContext, Link link) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onHeader(IIoContext ioContext, Header header) throws IOException, KgifReadWriteException {
            this.schemaVersionDate = header.getSchemaVersionDate();
            this.schemaVersionNumber = header.getSchemaVersionNumber();
            throw new RuntimeException("Done");
        }

        @Override
        public void onGraphStart(IIoContext ioContext, Metadata metadata) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onGraphEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onFooter(IIoContext ioContext, Footer footer) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onDocumentStart(IIoContext ioContext) throws IOException, KgifReadWriteException {
        }

        @Override
        public void onDocumentEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
        }

        @Override
        public void close() throws IOException, KgifReadWriteException {
        }
    }
}

