/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.utils.CookieUtils;

public class AdminAuthUtils {
    public static final Logger log = LoggerFactory.getLogger(AdminAuthUtils.class);
    static final String COOKIE_NAME_CONFIRM = "confirmCookie";

    public static void setTempAuthCookie(IRestlessContext context, String passwordPropertyNameInWebXml) {
        String password = context.getRestless().getInitParameter(passwordPropertyNameInWebXml);
        if (password == null) {
            throw new RuntimeException("Password not set in web.xml as init-param of Restless. So admin actions cannot be confirmed securely. Please set '" + passwordPropertyNameInWebXml + "' as a restless init param in web.xml");
        }
        CookieUtils.setCookie((HttpServletResponse)context.getResponse(), (String)COOKIE_NAME_CONFIRM, (String)password, null, null, (int)120);
    }

    public static void checkIfAuthorised(IRestlessContext context, String passwordPropertyNameInWebXml, String confirmParam) throws IllegalStateException {
        String password = context.getRestless().getInitParameter(passwordPropertyNameInWebXml);
        if (password == null) {
            throw new RuntimeException("Password not set in web.xml as init-param of Restless. So admin actions cannot be confirmed securely. Please set '" + passwordPropertyNameInWebXml + "' as a restless init param in web.xml");
        }
        String gotCookie = CookieUtils.getCookie((HttpServletRequest)context.getRequest(), (String)COOKIE_NAME_CONFIRM);
        log.info("Found confirm param='" + confirmParam + "' and cookie ='" + gotCookie + "'");
        if (confirmParam == null) {
            throw new IllegalStateException("No confirm param found");
        }
        if (gotCookie == null) {
            throw new IllegalStateException("No confirm cookie found (name='confirmCookie')");
        }
        if (!confirmParam.equals(gotCookie)) {
            throw new IllegalStateException("Cookie does not match confirmParam");
        }
    }
}

