/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.blobstore.UploadOptions;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.gaemyadmin.AppConstants;
import org.xydra.gaemyadmin.GaeMyAdmin_GaeTestfixer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.SharedHtmlUtils;

public class BlobAdminResource {
    private static final Logger log = LoggerFactory.getLogger(BlobAdminResource.class);
    static final String PAGE_NAME = "Blob Admin";
    static String URL;

    public static void restless(Restless restless, String prefix) {
        URL = prefix + "/blobs";
        restless.addMethod(URL, "GET", BlobAdminResource.class, "index", true, new RestlessParameter[0]);
        restless.addMethod(URL, "POST", BlobAdminResource.class, "upload", true, new RestlessParameter[0]);
        restless.addMethod(URL, "GET", BlobAdminResource.class, "download", true, new RestlessParameter[]{new RestlessParameter("name")});
    }

    public void index(HttpServletResponse res, HttpServletRequest req) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "");
        BlobstoreService blobStoreService = BlobstoreServiceFactory.getBlobstoreService();
        w.write("<b>Status</b><br/>Upload seems to work, download does not.<br />\n");
        w.write("<b>Upload</b><br/>");
        String url = blobStoreService.createUploadUrl("/admin" + URL, UploadOptions.Builder.withMaxUploadSizeBytes((long)0x6400000L));
        w.write(SharedHtmlUtils.form((SharedHtmlUtils.METHOD)SharedHtmlUtils.METHOD.POST, (String)url).withInputFile("tempfile").withInputSubmit("Upload as 'tempfile'").toString());
        w.write("<b>Download</b><br/>");
        w.write(SharedHtmlUtils.form((SharedHtmlUtils.METHOD)SharedHtmlUtils.METHOD.GET, (String)url).withInputText("name", "tempfile").withInputSubmit("Download").toString());
        AppConstants.endPage(w);
    }

    public void upload(HttpServletResponse res, HttpServletRequest req) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "");
        BlobstoreService blobStoreService = BlobstoreServiceFactory.getBlobstoreService();
        Map blobs = blobStoreService.getUploads(req);
        w.write(SharedHtmlUtils.toOrderedList(blobs.keySet()) + "<br/>\n");
        List keys = (List)blobs.get("tempfile");
        if (keys.isEmpty()) {
            w.write("No tempfiles uploaded");
        } else {
            for (BlobKey key : keys) {
                w.write("Have a tempfile uploaded. Key is '" + key.getKeyString() + "'");
            }
        }
        AppConstants.endPage(w);
    }

    public void download(String name, HttpServletResponse res, HttpServletRequest req) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        BlobstoreService blobStoreService = BlobstoreServiceFactory.getBlobstoreService();
        BlobKey blobKey = new BlobKey(name);
        blobStoreService.serve(blobKey, res);
    }
}

