/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.Sampler;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ForwardingMap;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.MapMaker;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class AllocationRecorder {
    private static volatile Instrumentation instrumentation;
    private static volatile Sampler[] additionalSamplers;
    private static final Object samplerLock;
    private static final List<String> classNames;
    private static final ThreadLocal<Boolean> recordingAllocation;
    private static final ForwardingMap<Class<?>, Long> classSizesMap;

    static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    static void setInstrumentation(Instrumentation inst) {
        instrumentation = inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSampler(Sampler sampler) {
        Object object = samplerLock;
        synchronized (object) {
            Sampler[] samplers = additionalSamplers;
            if (samplers != null) {
                Sampler[] newSamplers = new Sampler[samplers.length + 1];
                System.arraycopy(samplers, 0, newSamplers, 0, samplers.length);
                newSamplers[samplers.length] = sampler;
                additionalSamplers = newSamplers;
            } else {
                Sampler[] newSamplers = new Sampler[]{sampler};
                additionalSamplers = newSamplers;
            }
        }
    }

    private static long getObjectSize(Object obj, boolean isArray) {
        if (isArray) {
            return instrumentation.getObjectSize(obj);
        }
        Class<?> clazz = obj.getClass();
        Long classSize = classSizesMap.get(clazz);
        if (classSize == null) {
            classSize = instrumentation.getObjectSize(obj);
            classSizesMap.put(clazz, classSize);
        }
        return classSize;
    }

    public static void recordAllocation(Class<?> cls, Object newObj) {
        String typename = cls.getName().replace(".", "/");
        AllocationRecorder.recordAllocation(-1, typename, newObj);
    }

    public static void recordAllocation(int count, String desc, Object newObj) {
        if (recordingAllocation.get() == Boolean.TRUE) {
            return;
        }
        recordingAllocation.set(Boolean.TRUE);
        if (instrumentation != null) {
            long objectSize = -1L;
            Sampler[] samplers = additionalSamplers;
            if (samplers != null) {
                if (objectSize < 0L) {
                    objectSize = AllocationRecorder.getObjectSize(newObj, count >= 0);
                }
                for (Sampler sampler : samplers) {
                    sampler.sampleAllocation(count, desc, newObj, objectSize);
                }
            }
        }
        recordingAllocation.set(Boolean.FALSE);
    }

    public static void recordAllocationForceForTest(int count, String desc, Object newObj) {
        AllocationRecorder.recordAllocationForceForTestReal(count, desc, newObj, 2);
    }

    public static void recordAllocationForceForTestReal(int count, String desc, Object newObj, int recurse) {
        if (recurse != 0) {
            AllocationRecorder.recordAllocationForceForTestReal(count, desc, newObj, recurse - 1);
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AllocationRecorder.setInstrumentation(null);
            }
        });
        instrumentation = null;
        samplerLock = new Object();
        classNames = new ArrayList<String>();
        classNames.add("com.google.monitoring.runtime.");
        recordingAllocation = new ThreadLocal();
        classSizesMap = new ForwardingMap<Class<?>, Long>(){
            private final ConcurrentMap<Class<?>, Long> map = new MapMaker().weakKeys().makeMap();
            private static final int MAX_SIZE = 100000;
            private int approximateSize = 0;

            @Override
            public Map<Class<?>, Long> delegate() {
                return this.map;
            }

            @Override
            public Long put(Class<?> key, Long value) {
                if (this.approximateSize >= 100000) {
                    Iterator it = this.keySet().iterator();
                    while (it.hasNext()) {
                        it.next();
                        if (!(Math.random() < 0.1)) continue;
                        it.remove();
                    }
                    this.approximateSize = this.size();
                }
                ++this.approximateSize;
                return super.put(key, value);
            }
        };
    }
}

