/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.mem;

import de.xam.cmodel.fact.IChangeData;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.mem.ItemSetMem;
import de.xam.itemset.impl.mem.PropertyMem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractEntityMem
implements IEntity {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityMem.class);
    private final XId id;
    private final ItemSetMem itemSet;
    private IChangeData changeData;
    private final Map<XId, XValue> atts = new HashMap<XId, XValue>();
    private final Map<XId, PropertyMem> props = new HashMap<XId, PropertyMem>();

    public AbstractEntityMem(ItemSetMem itemSet, XId id) {
        this.itemSet = itemSet;
        this.id = id;
    }

    public IChangeData getChangeData() {
        return this.changeData;
    }

    public String dump() {
        log.info(this.toDebugString());
        return "";
    }

    public XId getId() {
        return this.id;
    }

    public boolean setAttribute(XId attributeId, XValue attributeValue) {
        XValue previousValue = this.atts.put(attributeId, attributeValue);
        return previousValue == null || !previousValue.equals(attributeValue);
    }

    public XValue getAttribute(XId attributeId) {
        return this.atts.get(attributeId);
    }

    public Iterator<XId> attributes() {
        return this.atts.keySet().iterator();
    }

    @Override
    public boolean setProperty(XId propertyKey, XValue propertyValue, IChangeData changeData) {
        PropertyMem prop = this.props.get(propertyKey);
        if (prop == null) {
            XId propId = Base.createUniqueId();
            prop = new PropertyMem(this.itemSet, propId, this.getId(), propertyKey);
            this.props.put(propertyKey, prop);
        }
        boolean change = prop.setPropertyValue(propertyValue, changeData);
        return change;
    }

    @Override
    public XValue getProperty(XId propertyKey) {
        PropertyMem prop = this.props.get(propertyKey);
        if (prop == null) {
            return null;
        }
        return prop.getPropertyValue();
    }

    @Override
    public Iterator<XId> properties() {
        return this.props.keySet().iterator();
    }

    @Override
    public Iterator<XId> getRelatedBy(XId relationId) {
        return ItemSets.getRelatedBy(this.itemSet, this.getId(), relationId);
    }

    @Override
    public Iterator<XId> relations() {
        return null;
    }

    @Override
    public boolean hasRelated(XId relationId, XId targetId) {
        return ItemSets.hasRelated(this.itemSet, this.getId(), relationId, targetId);
    }

    public IItemSet itemSet() {
        return this.itemSet;
    }
}

