/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.xydra;

import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.IHasAttributes;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.util.XydraUtils;
import de.xam.itemset.Attributes;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.xydra.ItemSetXy;
import de.xam.p13n.shared.time.TimeProvider;
import java.util.Iterator;
import java.util.Set;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;

public abstract class EntityXy
implements IEntity,
IChangeData,
IHasAttributes {
    protected transient ItemSetXy itemSet;
    protected transient XWritableObject xobject;

    EntityXy(ItemSetXy model, XWritableObject object) {
        this.itemSet = model;
        this.xobject = object;
    }

    public XId getId() {
        return this.xobject.getId();
    }

    public XAddress getAddress() {
        return this.xobject.getAddress();
    }

    public XWritableObject getXObject() {
        return this.xobject;
    }

    public String toDebugString() {
        return "id= " + this.getId() + " xobject=" + this.xobject.toString();
    }

    public String dump() {
        DumpUtilsBase.dump((String)"", (XReadableObject)this.xobject);
        return "";
    }

    public void setCreationDate(long creationDateUTC) {
        this.setAttribute(VocabularyCModel.ATTRIBUTE_CREATION_DATE, (XValue)XV.toValue((long)creationDateUTC));
    }

    public void setCreationSource(String creationSource) {
        this.setAttribute(VocabularyCModel.ATTRIBUTE_CREATION_SOURCE, (XValue)XV.toValue((String)creationSource));
    }

    public void setCreatedBy(String createdBy) {
        XydraUtils.setFieldValue((XWritableObject)this.xobject, (XId)VocabularyCModel.ATTRIBUTE_CREATED_BY, (XValue)XV.toValue((String)createdBy));
    }

    protected void setLastModifiedToNow() {
        long now = TimeProvider.getCurrentTimeInMillis();
        this.setAttribute(VocabularyCModel.ATTRIBUTE_LAST_MODIFIED, (XValue)XV.toValue((long)now));
    }

    public long getLastModifiedUTC() {
        return Attributes.getLongAttribute(this, VocabularyCModel.ATTRIBUTE_LAST_MODIFIED);
    }

    public long getCreationDateUTC() {
        return Attributes.getLongAttribute(this, VocabularyCModel.ATTRIBUTE_CREATION_DATE);
    }

    public IChangeData getChangeData() {
        return this;
    }

    public String getCreationSource() {
        return Attributes.getStringAttribute(this, VocabularyCModel.ATTRIBUTE_CREATION_SOURCE);
    }

    public String getCreatedBy() {
        return Attributes.getStringAttribute(this, VocabularyCModel.ATTRIBUTE_CREATED_BY);
    }

    public void setType(VocabularyCModel.Type type) {
        Attributes.setStringAttribute(this, VocabularyCModel.ATTRIBUTE_TYPE, type.name());
    }

    protected boolean removeIdFromFieldIdSetValue(XId fieldId, XId removeId) {
        return XydraUtils.removeIdFromIdSetValue((XWritableObject)this.xobject, (XId)fieldId, (XId)removeId);
    }

    protected void addIdToIdFieldSetValue(XId fieldId, XId addId) {
        XydraUtils.addIdToIdSetValue((XWritableObject)this.xobject, (XId)fieldId, (XId)addId);
    }

    protected Iterator<XId> getFieldIdSetValue(XId fieldId) {
        return XydraUtils.getIdSetValue((XWritableObject)this.xobject, (XId)fieldId);
    }

    protected XId getFieldValueAsId(XId id) {
        XValue v = XydraUtils.getFieldValue((XReadableObject)this.xobject, (XId)id);
        return (XId)v;
    }

    public boolean setAttribute(XId attributeId, XValue attributeValue) {
        return XydraUtils.setFieldValue((XWritableObject)this.xobject, (XId)attributeId, (XValue)attributeValue);
    }

    public XValue getAttribute(XId attributeId) {
        return XydraUtils.getFieldValue((XReadableObject)this.xobject, (XId)attributeId);
    }

    public Iterator<XId> attributes() {
        return this.xobject.iterator();
    }

    @Override
    public Iterator<XId> relations() {
        return this.itemSet.getTripleIndex().getPredicates_SXX((Object)this.getId());
    }

    @Override
    public boolean hasRelated(XId relationId, XId targetId) {
        return ItemSets.hasRelated(this.itemSet, this.getId(), relationId, targetId);
    }

    @Override
    public Iterator<XId> getRelatedBy(XId relationId) {
        return ItemSets.getRelatedBy(this.itemSet, this.getId(), relationId);
    }

    @Override
    public boolean setProperty(XId propertyKey, XValue propertyValue, IChangeData changeData) {
        return ItemSets.setProperty(this.itemSet, this.getId(), propertyKey, propertyValue, changeData);
    }

    @Override
    public XValue getProperty(XId propertyId) {
        return ItemSets.getPropertyValue(this.itemSet, this.getId(), propertyId);
    }

    @Override
    public Iterator<XId> properties() {
        Set<IProperty> props = this.itemSet.getPropertiesFor(this.getId(), null);
        return Iterators.transform(props.iterator(), (ITransformer)new ITransformer<IProperty, XId>(){

            public XId transform(IProperty property) {
                assert (property.getWritableContent().getContentValue() != null);
                return property.getPropertyKey();
            }
        });
    }

    public void setEntityMetaData(IChangeData entityMetaData) {
        long creationDate = entityMetaData.getCreationDateUTC();
        if (creationDate > 0L) {
            this.setCreationDate(creationDate);
        }
        this.setCreationSource(entityMetaData.getCreationSource());
        this.setCreatedBy(entityMetaData.getCreatedBy());
        long lastModifiedDate = entityMetaData.getLastModifiedUTC();
        if (lastModifiedDate > 0L) {
            this.setAttribute(VocabularyCModel.ATTRIBUTE_LAST_MODIFIED, (XValue)XV.toValue((long)lastModifiedDate));
        }
    }

    public int hashCode() {
        return this.xobject.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityXy other = (EntityXy)obj;
        return this.getId().equals((Object)other.getId());
    }

    public IItemSet itemSet() {
        return this.itemSet;
    }
}

