/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import java.io.File;
import java.io.IOException;

public class FilenameUtils {
    public static File getTargetFile(File srcDir, File srcFile, File targetDir) throws IOException {
        String srcPath = srcFile.getCanonicalPath();
        String srcDirPath = srcDir.getCanonicalPath();
        String targetDirPath = targetDir.getCanonicalPath();
        String targetPath = FilenameUtils.getTargetFilePathIntern(srcPath, srcDirPath, targetDirPath);
        File targetFile = new File(targetPath);
        return targetFile;
    }

    public static String getRelativePath(File srcDir, File srcFile) throws IOException {
        String srcDirPath;
        String srcPath = srcFile.getCanonicalPath();
        if (!srcPath.startsWith(srcDirPath = srcDir.getCanonicalPath())) {
            throw new IllegalArgumentException("\nsrcFile='" + srcPath + "' must be in\n srcDir='" + srcDirPath + "'");
        }
        String relativePath = srcPath.substring(srcDirPath.length());
        return relativePath;
    }

    public static String getTargetFilePath(String srcPath, String srcDirPath, String targetDirPath) throws IOException {
        return FilenameUtils.getTargetFile(new File(srcPath), new File(srcDirPath), new File(targetDirPath)).getCanonicalPath();
    }

    private static String getTargetFilePathIntern(String srcPath, String srcDirPath, String targetDirPath) throws IOException {
        String targetPath = targetDirPath + FilenameUtils.getRelativePath(new File(srcDirPath), new File(srcPath));
        return targetPath;
    }

    public static String getNameWithoutExtension(File f) {
        String s = f.getName();
        int i = s.indexOf(".");
        if (i < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    public static String getExtension(File f) {
        String s = f.getName();
        return FilenameUtils.getExtension(s);
    }

    public static String getExtension(String fileName) {
        int i = fileName.indexOf(".");
        if (i < 0) {
            return null;
        }
        if (i + 1 == fileName.length()) {
            return "";
        }
        return fileName.substring(i + 1);
    }

    public static void main(String[] args) {
        File f = new File("/Users/xamde/_data_/_p_/2010/com.calpano.common-server/src/main/java/com/calpano/common/server/util/FilenameUtils.java");
        System.out.println(FilenameUtils.getNameWithoutExtension(f));
        System.out.println(FilenameUtils.getExtension(f));
    }
}

