/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import de.xam.files.FileMetaDataProviderService;
import de.xam.files.impl.serviceloader.DefaultFileAndFolderMetaDataProvider;
import de.xam.files.type.IFileTypeHandler;
import de.xam.md5.MD5;
import de.xam.md5.MD5File;
import de.xam.md5.MD5InputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HashUtils {
    private static Logger log = LoggerFactory.getLogger(HashUtils.class);

    public static String getHash(File f) throws IOException {
        byte[] byteHash;
        assert (!f.isDirectory());
        String ext = FilenameUtils.getExtension((String)f.getAbsolutePath());
        IFileTypeHandler handler = FileMetaDataProviderService.getBestFileTypeHandlerByExt(ext);
        assert (handler != null) : "we have a default handler so this can never be null";
        if (handler instanceof DefaultFileAndFolderMetaDataProvider) {
            assert (!f.isDirectory());
            byteHash = MD5File.getHash((File)f);
        } else {
            FileInputStream fin = new FileInputStream(f);
            long headerLength = handler.getMetadataHeaderByteLength(fin);
            log.debug("Found " + headerLength + " header bytes");
            fin.close();
            fin = new FileInputStream(f);
            int i = 0;
            while ((long)i < headerLength) {
                fin.read();
                ++i;
            }
            byteHash = HashUtils.getHash(fin, f.length() - headerLength);
        }
        String hashString = MD5.asHex((byte[])byteHash);
        return hashString;
    }

    public static String getCompleteFileHash(File f) throws IOException {
        assert (!f.isDirectory());
        byte[] hash = MD5File.getHash((File)f);
        String hashString = MD5.asHex((byte[])hash);
        return hashString;
    }

    public static byte[] getHash(InputStream fin, long bodyLength) throws IOException {
        InputStream close_me = null;
        try {
            long buf_size = bodyLength;
            if (buf_size < 512L) {
                buf_size = 512L;
            }
            if (buf_size > 65536L) {
                buf_size = 65536L;
            }
            byte[] buf = new byte[(int)buf_size];
            MD5InputStream in = new MD5InputStream(fin);
            close_me = in;
            while (in.read(buf) != -1) {
            }
            in.close();
            return in.hash();
        }
        catch (IOException e) {
            close_me.close();
            throw e;
        }
    }
}

