/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.logical;

import de.xam.dwzmodel.graph.logical.LogicalEntity;
import de.xam.dwzmodel.graph.logical.LogicalGraph;
import de.xam.dwzmodel.graph.logical.LogicalLink;
import de.xam.itemset.EntityType;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.json.JON;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import org.xydra.base.XId;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.ITripleIndex;
import org.xydra.index.ITripleSource;
import org.xydra.index.impl.FastContainsSerializableTripleIndex;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.query.ITriple;

public class LogicalNode
extends LogicalEntity
implements Comparable<LogicalNode> {
    public static final String ATT_DEPTH = "depth";
    private final IEntity baseEntity;
    private transient MapSetIndex<XId, LogicalLink> relId_links = null;
    private MapSetIndex<XId, LogicalLink> targetId_links = null;
    private transient ITripleIndex<XId, XId, XId> tripleIndex = new FastContainsSerializableTripleIndex();
    private final int depth;

    public LogicalNode(LogicalGraph logicalGraph, IEntity baseEntity, int depth) {
        super(logicalGraph);
        this.baseEntity = baseEntity;
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public JON getJsonAtts() {
        JON attributes = JON.create();
        attributes.putNumber(ATT_DEPTH, new Number[]{this.getDepth()});
        return attributes;
    }

    public String getLabel() {
        EntityType type = EntityType.getType((IEntity)this.baseEntity);
        switch (type) {
            case Item: {
                return this.getGraph().toDisplayString((IItem)this.baseEntity);
            }
            case Property: {
                IProperty prop = (IProperty)this.baseEntity;
                return "PROPERTY " + prop.getId();
            }
            case Statement: {
                IStatement stmt = (IStatement)this.baseEntity;
                return "STATEMENT " + stmt.getId();
            }
        }
        throw new AssertionError();
    }

    public Set<LogicalLink> getLinks(XId targetId) {
        if (this.targetId_links == null) {
            return Collections.emptySet();
        }
        IEntrySet set = this.targetId_links.lookup((Object)targetId);
        if (set == null) {
            return Collections.emptySet();
        }
        return set.toSet();
    }

    public Set<LogicalLink> getLinksWithType(XId relId) {
        if (this.relId_links == null) {
            return Collections.emptySet();
        }
        IEntrySet set = this.relId_links.lookup((Object)relId);
        if (set == null) {
            return Collections.emptySet();
        }
        return set.toSet();
    }

    public IEntity getBaseEntity() {
        return this.baseEntity;
    }

    public Set<XId> getTargetIds() {
        if (this.targetId_links == null) {
            return Collections.emptySet();
        }
        return this.targetId_links.keySet();
    }

    public ITripleSource<XId, XId, XId> getTripleIndex() {
        return this.tripleIndex;
    }

    public boolean indexLink(LogicalGraph graph, LogicalLink link) {
        XId endId;
        boolean success;
        if (this.targetId_links == null) {
            this.targetId_links = new MapSetIndex((Factory)new FastEntrySetFactory());
        }
        if (this.relId_links == null) {
            this.relId_links = new MapSetIndex((Factory)new FastEntrySetFactory());
        }
        if (success = this.targetId_links.index((Object)(endId = link.getEndId()), (Object)link)) {
            ITriple<XId, XId, XId> triple = link.asTriple();
            this.tripleIndex.index(triple.s(), triple.p(), triple.o());
            this.relId_links.index(triple.p(), (Object)link);
        }
        return success;
    }

    public static int compare(IEntity o1, IEntity o2) {
        int i = EntityType.getType((IEntity)o1).compareTo((Enum)EntityType.getType((IEntity)o2));
        if (i != 0) {
            return i;
        }
        return o1.getId().compareTo((Object)o2.getId());
    }

    @Override
    public int compareTo(LogicalNode o) {
        return LogicalNode.compare(this.baseEntity, o.baseEntity);
    }

    public SortedSet<IEntity> getBaseEntities() {
        return null;
    }
}

