/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.calc;

public class TriplePattern<K, L, M>
implements Comparable<TriplePattern<K, L, M>> {
    private K s;
    private L p;
    private M o;
    private double score = 0.0;

    public String toString() {
        return "(" + (this.s == null ? "*" : this.s) + "," + (this.p == null ? "*" : this.p) + "," + (this.o == null ? "*" : this.o) + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.o == null ? 0 : this.o.hashCode());
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriplePattern other = (TriplePattern)obj;
        if (this.o == null ? other.o != null : !this.o.equals(other.o)) {
            return false;
        }
        if (this.p == null ? other.p != null : !this.p.equals(other.p)) {
            return false;
        }
        return !(this.s == null ? other.s != null : !this.s.equals(other.s));
    }

    public TriplePattern(K s, L p, M o) {
        this.s = s;
        this.p = p;
        this.o = o;
    }

    boolean contains(TriplePattern<K, L, M> other) {
        boolean containsS = this.s == null || this.s.equals(other.s);
        boolean containsP = this.p == null || this.p.equals(other.p);
        boolean containsO = this.o == null || this.o.equals(other.o);
        return containsS && containsP && containsO;
    }

    public K s() {
        return this.s;
    }

    public L p() {
        return this.p;
    }

    public M o() {
        return this.o;
    }

    public TriplePattern<K, L, M> clone() {
        return new TriplePattern<K, L, M>(this.s, this.p, this.o);
    }

    public void setS(K s) {
        this.s = s;
    }

    public void setP(L p) {
        this.p = p;
    }

    public void setO(M o) {
        this.o = o;
    }

    public double getScore() {
        return this.score;
    }

    public void addScore(double d) {
        this.score += d;
    }

    @Override
    public int compareTo(TriplePattern<K, L, M> other) {
        int i = (int)Math.signum(other.getScore() - this.getScore());
        if (i != 0) {
            return i;
        }
        i = TriplePattern.compare(this.s(), other.s());
        if (i != 0) {
            return i;
        }
        i = TriplePattern.compare(this.p(), other.p());
        if (i != 0) {
            return i;
        }
        i = TriplePattern.compare(this.o(), other.o());
        if (i != 0) {
            return i;
        }
        return this.toString().compareTo(other.toString());
    }

    private static int compare(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        return 0;
    }
}

