/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.visual;

import com.google.common.collect.Sets;
import de.xam.dwzmodel.graph2.visual.RelationPreferences;
import de.xam.dwzmodel.graph2.visual.VisualEntity;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.dwzmodel.graph2.visual.VisualGraphs;
import de.xam.dwzmodel.graph2.visual.VisualLinkType;
import de.xam.dwzmodel.graph2.visual.VisualNode;
import de.xam.json.JON;
import java.util.HashSet;
import java.util.Set;
import org.xydra.base.XId;

public class VisualLink
extends VisualEntity
implements Comparable<VisualLink> {
    private final XId relationType;
    private final VisualNode source;
    private final VisualNode target;
    private VisualLinkType type = VisualLinkType.normal;
    private String label;

    public VisualLink(VisualGraph visualGraph, VisualNode source, XId relationType, VisualNode target) {
        super(visualGraph);
        assert (source != null);
        assert (target != null);
        assert (relationType != null);
        this.source = source;
        this.relationType = relationType;
        this.target = target;
    }

    @Override
    public int compareTo(VisualLink o) {
        int i = this.getSource().compareTo(o.getSource());
        if (i != 0) {
            return i;
        }
        i = this.getTarget().compareTo(o.getTarget());
        if (i != 0) {
            return i;
        }
        double a = RelationPreferences.getRelationPreference(this.getRelationType());
        double b = RelationPreferences.getRelationPreference(o.getRelationType());
        double comp = b - a;
        i = (int)Math.signum(comp);
        if (i != 0) {
            return i;
        }
        return this.relationType.compareTo((Object)o.getRelationType());
    }

    public boolean equals(Object other) {
        if (other instanceof VisualLink) {
            VisualLink o = (VisualLink)other;
            return this.getSource().equals(o.getSource()) && this.getTarget().equals(o.getTarget()) && this.getRelationType().equals((Object)o.getRelationType());
        }
        return false;
    }

    @Override
    public JON getJsonAttributes() {
        JON jsonAttributes = JON.create();
        jsonAttributes.putString("label", new String[]{this.getLabel()});
        jsonAttributes.putInt("typenumber", new Integer[]{this.type.ordinal()});
        jsonAttributes.putString("xid", new String[]{this.getRelationType().toString()});
        return jsonAttributes;
    }

    @Override
    public Set<String> getCssClasses() {
        HashSet css = Sets.newHashSet(super.getCssClasses());
        if (this.isFrontier()) {
            css.add("frontier");
        }
        return css;
    }

    private boolean isFrontier() {
        return this.getSource().isFrontier() || this.getTarget().isFrontier();
    }

    public String getLabel() {
        if (this.label == null) {
            return VisualGraphs.toLabel(this.getVisualGraph(), this.getRelationType());
        }
        return this.label;
    }

    public XId getRelationType() {
        return this.relationType;
    }

    public VisualNode getSource() {
        return this.source;
    }

    public VisualNode getTarget() {
        return this.target;
    }

    public int hashCode() {
        return this.getSource().hashCode() * this.getRelationType().hashCode() * this.getTarget().hashCode();
    }

    public String toString() {
        return "VisualLink " + this.getSource().toString() + "--(" + this.relationType + ")-->" + this.getTarget().toString();
    }

    public void setType(VisualLinkType type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

