/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.persistence;

import de.xam.mybase.model.IoProgressReporter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class JavaObjectStreamIO {
    private static final Logger log = LoggerFactory.getLogger(JavaObjectStreamIO.class);

    public static <T> T readFromBinaryJavaObjectStream(File f, IoProgressReporter iop) throws IOException {
        if (f == null || f.length() == 0L) {
            return null;
        }
        iop.reportProgress("Streaming data in from " + f.getAbsolutePath());
        FileInputStream fis = new FileInputStream(f);
        ObjectInputStream ois = null;
        try {
            Object result;
            ois = new ObjectInputStream(fis);
            Object object = result = ois.readObject();
            return (T)object;
        }
        catch (EOFException e) {
            log.error("Failed to load via object stream from " + f.getAbsolutePath(), (Throwable)e);
            T t = null;
            return t;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error", e);
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            fis.close();
        }
    }

    public static <T> void writeToBinaryJavaObjectStream(T object, File f) throws IOException {
        f.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(f);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(object);
        oos.close();
        fos.close();
    }
}

