/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.kgif.io.FileFormat;
import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.impl.OutputStreamSink;
import de.xam.dwzmodel.api.FileUpload;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.state.FileMeta;
import de.xam.dwzmodel.state.FileVersion;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.dwzmodel.state.StateManager;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.texthtml.text.HumanReadableText;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.xydra.annotations.Template;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IMultipartFormDataHandler;
import org.xydra.restless.IRestlessContext;

public class FileManager {
    private static final Logger log = LoggerFactory.getLogger(FileManager.class);
    private final StateManager stateManager;

    @Template(value="downloadName")
    public static String getDownloadName(FileFormat fileFormat, String filename) {
        String dateTime = HumanReadableText.fullDate((long)System.currentTimeMillis());
        String ext = fileFormat.getDefaultExtension();
        return filename + "--" + dateTime + (ext == null ? "" : "." + ext);
    }

    public FileManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void doClose() throws IOException {
        IMyBase myBase = ModuleManager.get().getMyBase();
        assert (myBase != null);
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[0]);
        this.stateManager.doClose(myBase, iop);
    }

    public CopyResult doCopyTo(long sourceRev, String tagetFilename, String format, IMultipartFormDataHandler.IProgressReporter progress) throws IOException {
        assert (tagetFilename != null);
        assert (format != null);
        assert (format.length() > 0);
        assert (progress != null);
        DwzFileFormats.init();
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[]{progress});
        FileFormat ff = FileFormats.getFormatByName((String)format);
        if (ff == null) {
            log.warn("Could not find fileFormat '" + format + "'");
            return null;
        }
        CopyResult copyResult = this.stateManager.doCopyTo(sourceRev, tagetFilename, ff, iop);
        return copyResult;
    }

    public boolean doCreateNew() throws IOException {
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[0]);
        this.stateManager.doCreateNew(iop);
        iop.reportProgressSuccessIfNoErrorSoFar();
        return iop.isSuccess();
    }

    public boolean doExportTo(IRestlessContext ctx, String filename, String format) throws IOException {
        assert (filename != null);
        assert (format != null);
        assert (format.length() > 0);
        DwzFileFormats.init();
        FileFormat ff = FileFormats.getFormatByName((String)format);
        if (ff == null) {
            log.warn("Could not find fileFormat '" + format + "'");
            return false;
        }
        HttpServletResponse res = ctx.getResponse();
        res.setHeader("Expires", "-1");
        res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        res.setHeader("Cache-Control", "private");
        String contentType = ff.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        res.setHeader("Content-Type", contentType);
        String downloadName = filename;
        res.setHeader("Content-Disposition", "attachment; filename=\"" + downloadName + "\";");
        res.setHeader("Content-Transfer-Encoding", "binary");
        ServletOutputStream outputStream = res.getOutputStream();
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[0]);
        OutputStreamSink sink = new OutputStreamSink("servlet-out", (OutputStream)outputStream);
        this.stateManager.doExportTo((IStreamSink)sink, ff, iop);
        sink.close();
        iop.reportProgressSuccessIfNoErrorSoFar();
        return iop.isSuccess();
    }

    public boolean doImportBuiltin(IRestlessContext ctx, String filename, IMultipartFormDataHandler.IProgressReporter progress) throws IOException {
        assert (filename != null);
        DwzFileFormats.init();
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[]{progress});
        this.stateManager.doImportBuiltin(filename, iop);
        if (iop.isSuccess()) {
            iop.reportProgressDone(true);
            return true;
        }
        log.warn("Could not import '" + filename + "'");
        return false;
    }

    public boolean doImportUpload(FileUpload upload, IMultipartFormDataHandler.IProgressReporter progress) throws IOException {
        assert (upload != null);
        DwzFileFormats.init();
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[]{progress});
        this.stateManager.doImportUpload(upload, iop);
        iop.reportProgressSuccessIfNoErrorSoFar();
        return iop.isSuccess();
    }

    public boolean doOpen(String filename, IMultipartFormDataHandler.IProgressReporter pr) throws IOException {
        assert (filename != null);
        DwzFileFormats.init();
        IoProgressReporter iop = new IoProgressReporter(new IMultipartFormDataHandler.IProgressReporter[]{pr});
        this.stateManager.doOpen(filename, iop);
        iop.reportProgressSuccessIfNoErrorSoFar();
        return iop.isSuccess();
    }

    public String getActiveLocalname() {
        return this.stateManager.getActiveFileName();
    }

    public File getPublicDir() {
        return this.stateManager.getPublicDir();
    }

    @Template(value="hasActiveFile")
    public boolean hasActiveFile() {
        return this.stateManager.getActiveFileName() != null;
    }

    public List<FileMeta> listFiles() throws IOException {
        IoProgressReporter iop = IoProgressReporter.createOnLogInfo((Logger)log);
        return this.stateManager.getLocalFileMetas(iop);
    }

    @Template(value="listVersions")
    public List<FileVersion> listVersions(long maxGapBetweenVersions, int maxEventsPerVersion) throws IOException {
        IoProgressReporter iop = IoProgressReporter.createOnLogInfo((Logger)log);
        return this.stateManager.getLocalFileVersions(maxGapBetweenVersions, maxEventsPerVersion, iop);
    }

    public static class CopyResult {
        public String targetName;
        public long targetRev;

        public CopyResult(String targetName, long targetRev) {
            this.targetName = targetName;
            this.targetRev = targetRev;
        }
    }
}

