/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.kgif.v1_1_0.gen.GraphMetadata;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.read.KgifReads;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.texthtml.text.HumanReadableText;
import de.xam.texthtml.text.TextTool;
import java.util.List;

public class FileMeta
implements Comparable<FileMeta> {
    private final long created;
    private long entityCount;
    private final String filenameNotEncoded;
    private final long fileSizeInBytes;
    private int graphCount;
    private final long lastModified;
    private final String meta;
    private final long rev;
    private String schemaVersionDate;
    private String schemaVersionNumber;
    private String toolName;
    private String toolVersionNumber;

    public static FileMeta createFromHeader(String filename, long fileSizeInBytes, Header header) {
        long lastModified = FileMeta.tryToParseLong(header.getFileLastModified(), -1L);
        long created = FileMeta.tryToParseLong(header.getFileCreated(), -1L);
        String meta = "";
        long rev = -20L;
        List list = header.getGraphMetadata();
        if (list != null && list.size() == 1) {
            GraphMetadata graphMeta = (GraphMetadata)list.get(0);
            Metadata metadata = graphMeta.getMetadata();
            meta = KgifReads.getAttributeValue((Metadata)metadata, (String)"tagCloud", (String)"");
            String revStr = KgifReads.getAttributeValue((Metadata)metadata, (String)"revision", null);
            rev = FileMeta.tryToParseLong(revStr, -20L);
        }
        FileMeta fm = new FileMeta(filename, lastModified, created, fileSizeInBytes, meta, rev);
        return fm;
    }

    private static long tryToParseLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public FileMeta(String filenameNotEncoded, long lastModified, long created, long fileSizeInBytes, String meta, long rev) {
        this.filenameNotEncoded = filenameNotEncoded;
        this.lastModified = lastModified;
        this.created = created;
        this.fileSizeInBytes = fileSizeInBytes;
        this.meta = meta;
        this.rev = rev;
    }

    @Override
    public int compareTo(FileMeta o) {
        assert (o != null);
        return TextTool.compare((String)this.filenameNotEncoded, (String)o.filenameNotEncoded, (boolean)false);
    }

    public String getCreated() {
        if (this.created == -1L) {
            return "n/a";
        }
        long ageInMs = TimeProvider.getCurrentTimeInMillis() - this.created;
        return HumanReadableText.niceTimespan((long)ageInMs);
    }

    public long getEntityCount() {
        return this.entityCount;
    }

    public String getFilename() {
        return this.filenameNotEncoded;
    }

    public int getGraphCount() {
        return this.graphCount;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getMeta() {
        return this.meta;
    }

    public String getNiceAge() {
        if (this.lastModified == -1L) {
            return "n/a";
        }
        long ageInMs = TimeProvider.getCurrentTimeInMillis() - this.getLastModified();
        return HumanReadableText.niceTimespan((long)ageInMs);
    }

    public long getRev() {
        return this.rev;
    }

    public String getSchemaVersionDate() {
        return this.schemaVersionDate;
    }

    public String getSchemaVersionNumber() {
        return this.schemaVersionNumber;
    }

    public String getSize() {
        return HumanReadableText.fileSize((long)this.fileSizeInBytes);
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getToolVersionNumber() {
        return this.toolVersionNumber;
    }

    public String toString() {
        return this.getFilename();
    }
}

