/*
 * Decompiled with CFR 0.152.
 */
package de.xam.color;

import de.xam.color.RGBColor;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.annotations.LicenseMPL;

@LicenseMPL(licenseVersion="1.1", modified=true)
public class MPL_ColorTool {
    protected static HashMap<String, RGBColor> namedColors = new HashMap();
    protected static final Pattern RGB_PATTERN = Pattern.compile("rgb\\(\\s?(\\d{1,3})%?\\s?,\\s?(\\d{1,3})%?\\s?,\\s?(\\d{1,3})(%?)\\s?\\)");

    private static void defineNamedColor(String name, RGBColor rgbColor) {
        namedColors.put(name, rgbColor);
    }

    public static RGBColor parse(String colorDef) throws IllegalArgumentException {
        Matcher m;
        String s = colorDef.trim();
        if (s.startsWith("#")) {
            if (s.length() == 4) {
                int r = Integer.parseInt(s.substring(1, 2) + s.charAt(1), 16);
                int g = Integer.parseInt(s.substring(2, 3) + s.charAt(2), 16);
                int b = Integer.parseInt(s.substring(3) + s.charAt(3), 16);
                return new RGBColor(r, g, b);
            }
            if (s.length() == 7) {
                int r = Integer.parseInt(s.substring(1, 3), 16);
                int g = Integer.parseInt(s.substring(3, 5), 16);
                int b = Integer.parseInt(s.substring(5), 16);
                return new RGBColor(r, g, b);
            }
        }
        if ((m = RGB_PATTERN.matcher(s)).matches()) {
            int r = Integer.parseInt(m.group(1));
            int g = Integer.parseInt(m.group(2));
            int b = Integer.parseInt(m.group(3));
            if ("%".equals(m.group(4))) {
                r = 255 * (r / 100);
                g = 255 * (g / 100);
                b = 255 * (b / 100);
            }
            return new RGBColor(r, g, b);
        }
        RGBColor color = namedColors.get(s.toLowerCase());
        if (color != null) {
            return color;
        }
        throw new IllegalArgumentException("Invalid color format: '" + s + "'");
    }

    public static RGBColor brightness(RGBColor c, double scale) {
        double r = c.getRed255();
        double g = c.getGreen255();
        double b = c.getBlue255();
        if (r == 0.0 && g == 0.0 && b == 0.0 && scale > 0.0) {
            g = b = (double)Math.min(255, (int)(255.0 * scale));
            r = b;
        } else {
            r = Math.max(0, (int)(r * scale));
            g = Math.max(0, (int)(g * scale));
            b = Math.max(0, (int)(b * scale));
            if (r > 255.0 || g > 255.0 || b > 255.0) {
                return c;
            }
        }
        return new RGBColor(r, g, b, c.getAlpha());
    }

    static {
        MPL_ColorTool.defineNamedColor("aliceblue", new RGBColor(240, 248, 255));
        MPL_ColorTool.defineNamedColor("antiquewhite", new RGBColor(250, 235, 215));
        MPL_ColorTool.defineNamedColor("aqua", new RGBColor(0, 255, 255));
        MPL_ColorTool.defineNamedColor("aquamarine", new RGBColor(127, 255, 212));
        MPL_ColorTool.defineNamedColor("azure", new RGBColor(240, 255, 255));
        MPL_ColorTool.defineNamedColor("beige", new RGBColor(245, 245, 220));
        MPL_ColorTool.defineNamedColor("bisque", new RGBColor(255, 228, 196));
        MPL_ColorTool.defineNamedColor("black", new RGBColor(0, 0, 0));
        MPL_ColorTool.defineNamedColor("blanchedalmond", new RGBColor(255, 235, 205));
        MPL_ColorTool.defineNamedColor("blue", new RGBColor(0, 0, 255));
        MPL_ColorTool.defineNamedColor("blueviolet", new RGBColor(138, 43, 226));
        MPL_ColorTool.defineNamedColor("brown", new RGBColor(165, 42, 42));
        MPL_ColorTool.defineNamedColor("burlywood", new RGBColor(222, 184, 135));
        MPL_ColorTool.defineNamedColor("cadetblue", new RGBColor(95, 158, 160));
        MPL_ColorTool.defineNamedColor("chartreuse", new RGBColor(127, 255, 0));
        MPL_ColorTool.defineNamedColor("chocolate", new RGBColor(210, 105, 30));
        MPL_ColorTool.defineNamedColor("coral", new RGBColor(255, 127, 80));
        MPL_ColorTool.defineNamedColor("cornflowerblue", new RGBColor(100, 149, 237));
        MPL_ColorTool.defineNamedColor("cornsilk", new RGBColor(255, 248, 220));
        MPL_ColorTool.defineNamedColor("crimson", new RGBColor(220, 20, 60));
        MPL_ColorTool.defineNamedColor("cyan", new RGBColor(0, 255, 255));
        MPL_ColorTool.defineNamedColor("darkblue", new RGBColor(0, 0, 139));
        MPL_ColorTool.defineNamedColor("darkcyan", new RGBColor(0, 139, 139));
        MPL_ColorTool.defineNamedColor("darkgoldenrod", new RGBColor(184, 134, 11));
        MPL_ColorTool.defineNamedColor("darkgray", new RGBColor(169, 169, 169));
        MPL_ColorTool.defineNamedColor("darkgrey", new RGBColor(169, 169, 169));
        MPL_ColorTool.defineNamedColor("darkgreen", new RGBColor(0, 100, 0));
        MPL_ColorTool.defineNamedColor("darkkhaki", new RGBColor(189, 183, 107));
        MPL_ColorTool.defineNamedColor("darkmagenta", new RGBColor(139, 0, 139));
        MPL_ColorTool.defineNamedColor("darkolivegreen", new RGBColor(85, 107, 47));
        MPL_ColorTool.defineNamedColor("darkorange", new RGBColor(255, 140, 0));
        MPL_ColorTool.defineNamedColor("darkorchid", new RGBColor(153, 50, 204));
        MPL_ColorTool.defineNamedColor("darkred", new RGBColor(139, 0, 0));
        MPL_ColorTool.defineNamedColor("darksalmon", new RGBColor(233, 150, 122));
        MPL_ColorTool.defineNamedColor("darkseagreen", new RGBColor(143, 188, 143));
        MPL_ColorTool.defineNamedColor("darkslateblue", new RGBColor(72, 61, 139));
        MPL_ColorTool.defineNamedColor("darkslategray", new RGBColor(47, 79, 79));
        MPL_ColorTool.defineNamedColor("darkslategrey", new RGBColor(47, 79, 79));
        MPL_ColorTool.defineNamedColor("darkturquoise", new RGBColor(0, 206, 209));
        MPL_ColorTool.defineNamedColor("darkviolet", new RGBColor(148, 0, 211));
        MPL_ColorTool.defineNamedColor("deeppink", new RGBColor(255, 20, 147));
        MPL_ColorTool.defineNamedColor("deepskyblue", new RGBColor(0, 191, 255));
        MPL_ColorTool.defineNamedColor("dimgray", new RGBColor(105, 105, 105));
        MPL_ColorTool.defineNamedColor("dimgrey", new RGBColor(105, 105, 105));
        MPL_ColorTool.defineNamedColor("dodgerblue", new RGBColor(30, 144, 255));
        MPL_ColorTool.defineNamedColor("firebrick", new RGBColor(178, 34, 34));
        MPL_ColorTool.defineNamedColor("floralwhite", new RGBColor(255, 250, 240));
        MPL_ColorTool.defineNamedColor("forestgreen", new RGBColor(34, 139, 34));
        MPL_ColorTool.defineNamedColor("fuchsia", new RGBColor(255, 0, 255));
        MPL_ColorTool.defineNamedColor("gainsboro", new RGBColor(220, 220, 220));
        MPL_ColorTool.defineNamedColor("ghostwhite", new RGBColor(248, 248, 255));
        MPL_ColorTool.defineNamedColor("gold", new RGBColor(255, 215, 0));
        MPL_ColorTool.defineNamedColor("goldenrod", new RGBColor(218, 165, 32));
        MPL_ColorTool.defineNamedColor("gray", new RGBColor(128, 128, 128));
        MPL_ColorTool.defineNamedColor("grey", new RGBColor(128, 128, 128));
        MPL_ColorTool.defineNamedColor("green", new RGBColor(0, 128, 0));
        MPL_ColorTool.defineNamedColor("greenyellow", new RGBColor(173, 255, 47));
        MPL_ColorTool.defineNamedColor("honeydew", new RGBColor(240, 255, 240));
        MPL_ColorTool.defineNamedColor("hotpink", new RGBColor(255, 105, 180));
        MPL_ColorTool.defineNamedColor("indianred", new RGBColor(205, 92, 92));
        MPL_ColorTool.defineNamedColor("indigo", new RGBColor(75, 0, 130));
        MPL_ColorTool.defineNamedColor("ivory", new RGBColor(255, 255, 240));
        MPL_ColorTool.defineNamedColor("khaki", new RGBColor(240, 230, 140));
        MPL_ColorTool.defineNamedColor("lavender", new RGBColor(230, 230, 250));
        MPL_ColorTool.defineNamedColor("lavenderblush", new RGBColor(255, 240, 245));
        MPL_ColorTool.defineNamedColor("lawngreen", new RGBColor(124, 252, 0));
        MPL_ColorTool.defineNamedColor("lemonchiffon", new RGBColor(255, 250, 205));
        MPL_ColorTool.defineNamedColor("lightblue", new RGBColor(173, 216, 230));
        MPL_ColorTool.defineNamedColor("lightcoral", new RGBColor(240, 128, 128));
        MPL_ColorTool.defineNamedColor("lightcyan", new RGBColor(224, 255, 255));
        MPL_ColorTool.defineNamedColor("lightgoldenrodyellow", new RGBColor(250, 250, 210));
        MPL_ColorTool.defineNamedColor("lightgray", new RGBColor(211, 211, 211));
        MPL_ColorTool.defineNamedColor("lightgrey", new RGBColor(211, 211, 211));
        MPL_ColorTool.defineNamedColor("lightgreen", new RGBColor(144, 238, 144));
        MPL_ColorTool.defineNamedColor("lightpink", new RGBColor(255, 182, 193));
        MPL_ColorTool.defineNamedColor("lightsalmon", new RGBColor(255, 160, 122));
        MPL_ColorTool.defineNamedColor("lightseagreen", new RGBColor(32, 178, 170));
        MPL_ColorTool.defineNamedColor("lightskyblue", new RGBColor(135, 206, 250));
        MPL_ColorTool.defineNamedColor("lightslategray", new RGBColor(119, 136, 153));
        MPL_ColorTool.defineNamedColor("lightslategrey", new RGBColor(119, 136, 153));
        MPL_ColorTool.defineNamedColor("lightsteelblue", new RGBColor(176, 196, 222));
        MPL_ColorTool.defineNamedColor("lightyellow", new RGBColor(255, 255, 224));
        MPL_ColorTool.defineNamedColor("lime", new RGBColor(0, 255, 0));
        MPL_ColorTool.defineNamedColor("limegreen", new RGBColor(50, 205, 50));
        MPL_ColorTool.defineNamedColor("linen", new RGBColor(250, 240, 230));
        MPL_ColorTool.defineNamedColor("magenta", new RGBColor(255, 0, 255));
        MPL_ColorTool.defineNamedColor("maroon", new RGBColor(128, 0, 0));
        MPL_ColorTool.defineNamedColor("mediumaquamarine", new RGBColor(102, 205, 170));
        MPL_ColorTool.defineNamedColor("mediumblue", new RGBColor(0, 0, 205));
        MPL_ColorTool.defineNamedColor("mediumorchid", new RGBColor(186, 85, 211));
        MPL_ColorTool.defineNamedColor("mediumpurple", new RGBColor(147, 112, 216));
        MPL_ColorTool.defineNamedColor("mediumseagreen", new RGBColor(60, 179, 113));
        MPL_ColorTool.defineNamedColor("mediumslateblue", new RGBColor(123, 104, 238));
        MPL_ColorTool.defineNamedColor("mediumspringgreen", new RGBColor(0, 250, 154));
        MPL_ColorTool.defineNamedColor("mediumturquoise", new RGBColor(72, 209, 204));
        MPL_ColorTool.defineNamedColor("mediumvioletred", new RGBColor(199, 21, 133));
        MPL_ColorTool.defineNamedColor("midnightblue", new RGBColor(25, 25, 112));
        MPL_ColorTool.defineNamedColor("mintcream", new RGBColor(245, 255, 250));
        MPL_ColorTool.defineNamedColor("mistyrose", new RGBColor(255, 228, 225));
        MPL_ColorTool.defineNamedColor("moccasin", new RGBColor(255, 228, 181));
        MPL_ColorTool.defineNamedColor("navajowhite", new RGBColor(255, 222, 173));
        MPL_ColorTool.defineNamedColor("navy", new RGBColor(0, 0, 128));
        MPL_ColorTool.defineNamedColor("oldlace", new RGBColor(253, 245, 230));
        MPL_ColorTool.defineNamedColor("olive", new RGBColor(128, 128, 0));
        MPL_ColorTool.defineNamedColor("olivedrab", new RGBColor(107, 142, 35));
        MPL_ColorTool.defineNamedColor("orange", new RGBColor(255, 165, 0));
        MPL_ColorTool.defineNamedColor("orangered", new RGBColor(255, 69, 0));
        MPL_ColorTool.defineNamedColor("orchid", new RGBColor(218, 112, 214));
        MPL_ColorTool.defineNamedColor("palegoldenrod", new RGBColor(238, 232, 170));
        MPL_ColorTool.defineNamedColor("palegreen", new RGBColor(152, 251, 152));
        MPL_ColorTool.defineNamedColor("paleturquoise", new RGBColor(175, 238, 238));
        MPL_ColorTool.defineNamedColor("palevioletred", new RGBColor(216, 112, 147));
        MPL_ColorTool.defineNamedColor("papayawhip", new RGBColor(255, 239, 213));
        MPL_ColorTool.defineNamedColor("peachpuff", new RGBColor(255, 218, 185));
        MPL_ColorTool.defineNamedColor("peru", new RGBColor(205, 133, 63));
        MPL_ColorTool.defineNamedColor("pink", new RGBColor(255, 192, 203));
        MPL_ColorTool.defineNamedColor("plum", new RGBColor(221, 160, 221));
        MPL_ColorTool.defineNamedColor("powderblue", new RGBColor(176, 224, 230));
        MPL_ColorTool.defineNamedColor("purple", new RGBColor(128, 0, 128));
        MPL_ColorTool.defineNamedColor("red", new RGBColor(255, 0, 0));
        MPL_ColorTool.defineNamedColor("rosybrown", new RGBColor(188, 143, 143));
        MPL_ColorTool.defineNamedColor("royalblue", new RGBColor(65, 105, 225));
        MPL_ColorTool.defineNamedColor("saddlebrown", new RGBColor(139, 69, 19));
        MPL_ColorTool.defineNamedColor("salmon", new RGBColor(250, 128, 114));
        MPL_ColorTool.defineNamedColor("sandybrown", new RGBColor(244, 164, 96));
        MPL_ColorTool.defineNamedColor("seagreen", new RGBColor(46, 139, 87));
        MPL_ColorTool.defineNamedColor("seashell", new RGBColor(255, 245, 238));
        MPL_ColorTool.defineNamedColor("sienna", new RGBColor(160, 82, 45));
        MPL_ColorTool.defineNamedColor("silver", new RGBColor(192, 192, 192));
        MPL_ColorTool.defineNamedColor("skyblue", new RGBColor(135, 206, 235));
        MPL_ColorTool.defineNamedColor("slateblue", new RGBColor(106, 90, 205));
        MPL_ColorTool.defineNamedColor("slategray", new RGBColor(112, 128, 144));
        MPL_ColorTool.defineNamedColor("slategrey", new RGBColor(112, 128, 144));
        MPL_ColorTool.defineNamedColor("snow", new RGBColor(255, 250, 250));
        MPL_ColorTool.defineNamedColor("springgreen", new RGBColor(0, 255, 127));
        MPL_ColorTool.defineNamedColor("steelblue", new RGBColor(70, 130, 180));
        MPL_ColorTool.defineNamedColor("tan", new RGBColor(210, 180, 140));
        MPL_ColorTool.defineNamedColor("teal", new RGBColor(0, 128, 128));
        MPL_ColorTool.defineNamedColor("thistle", new RGBColor(216, 191, 216));
        MPL_ColorTool.defineNamedColor("tomato", new RGBColor(255, 99, 71));
        MPL_ColorTool.defineNamedColor("turquoise", new RGBColor(64, 224, 208));
        MPL_ColorTool.defineNamedColor("violet", new RGBColor(238, 130, 238));
        MPL_ColorTool.defineNamedColor("wheat", new RGBColor(245, 222, 179));
        MPL_ColorTool.defineNamedColor("white", new RGBColor(255, 255, 255));
        MPL_ColorTool.defineNamedColor("whitesmoke", new RGBColor(245, 245, 245));
        MPL_ColorTool.defineNamedColor("yellow", new RGBColor(255, 255, 0));
        MPL_ColorTool.defineNamedColor("yellowgreen", new RGBColor(154, 205, 50));
    }
}

