/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.user.pipe.link;

import de.xam.texthtml.text.AnnotatedString;
import de.xam.texthtml.text.CamelCase;
import de.xam.texthtml.text.JspWikiSyntax;
import de.xam.tokenpipe.user.pipe.link.LinkFinders;
import de.xam.tokenpipe.user.pipe.link.LinkInfo;
import de.xam.tokenpipe.user.pipe.link.LinkType;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkFinder;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.xydra.index.impl.IntegerRangeIndex;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ManualLinkFinder
implements ILinkFinder {
    private static final Logger log = LoggerFactory.getLogger(ManualLinkFinder.class);

    @Override
    public void findLinks(AnnotatedString<LinkInfo> annotatedContent) {
        ManualLinkFinder.findManualLinks(annotatedContent);
    }

    private static void findManualLinks(AnnotatedString<LinkInfo> annotatedContent) {
        if (log.isTraceEnabled()) {
            log.trace("Finding manual links in \n" + annotatedContent);
        }
        ManualLinkFinder.findBracedLinks(annotatedContent);
        LinkFinders.findAndIndexNonOverlappingMatches(JspWikiSyntax.pattern_FIND_FULL_HTTP_URL, LinkType.FullUrl, annotatedContent);
        LinkFinders.findAndIndexNonOverlappingMatches(JspWikiSyntax.pattern_FIND_FILE_URL, LinkType.FullUrl, annotatedContent);
        LinkFinders.findAndIndexNonOverlappingMatches(JspWikiSyntax.pattern_FIND_PARTIAL_URL, LinkType.PartialUrlWithoutScheme, annotatedContent);
        LinkFinders.findAndIndexNonOverlappingMatches(JspWikiSyntax.pattern_FIND_EMAIL, LinkType.FullEmail, annotatedContent);
        for (IntegerRangeIndex.Span span : annotatedContent.spansNotInRangeList()) {
            String spanContent = annotatedContent.getString(span);
            Matcher m_camelCase = CamelCase.pattern_CAMELCASE.matcher(spanContent);
            while (m_camelCase.find()) {
                int startInclusive = span.getStartInclusive() + m_camelCase.start(0);
                int endExclusive = span.getStartInclusive() + m_camelCase.end(0);
                assert (startInclusive >= 0);
                assert (endExclusive >= 0);
                assert (startInclusive <= endExclusive) : "start=" + startInclusive + " end=" + endExclusive;
                if (log.isTraceEnabled()) {
                    String found = annotatedContent.getString().substring(startInclusive, endExclusive);
                    log.trace("Found manual link: '" + found + "' of type " + (Object)((Object)LinkType.CamelCaseWikiLink));
                }
                annotatedContent.addAnnotation(startInclusive, endExclusive - 1, (Object)new LinkInfo(LinkType.CamelCaseWikiLink));
            }
        }
        Iterator spanIt = annotatedContent.spanIterator();
        while (spanIt.hasNext()) {
            IntegerRangeIndex.Span span;
            span = (IntegerRangeIndex.Span)spanIt.next();
            if (!span.isInRange()) continue;
            AnnotatedString.AnnotatedSpan annSpan = annotatedContent.getAnnotationStartingAt(span.getStartInclusive());
            LinkInfo linkInfo = (LinkInfo)annSpan.getAnnotation();
            linkInfo.setLinkText(annotatedContent.getString(annSpan));
            assert (linkInfo != null);
            LinkType linkType = linkInfo.getLinkType();
            assert (linkType != null);
            String tokenContent = annotatedContent.getString(span);
            switch (linkType) {
                case FullUrl: {
                    linkInfo.setLinkText(tokenContent);
                    linkInfo.setLinkTargetName(tokenContent);
                    linkInfo.setLinkCause(ILinkListener.LinkCause.valueOf("url"));
                    break;
                }
                case PartialUrlWithoutScheme: {
                    linkInfo.setLinkText(tokenContent);
                    linkInfo.setLinkTargetName("http://" + tokenContent);
                    linkInfo.setLinkCause(ILinkListener.LinkCause.valueOf("url"));
                    break;
                }
                case FullEmail: {
                    linkInfo.setLinkText(tokenContent);
                    linkInfo.setLinkTargetName(tokenContent);
                    linkInfo.setLinkCause(ILinkListener.LinkCause.valueOf("url"));
                    break;
                }
                case CamelCaseWikiLink: {
                    linkInfo.setLinkText(tokenContent);
                    linkInfo.setLinkTargetName(tokenContent);
                    linkInfo.setLinkCause(ILinkListener.LinkCause.valueOf("wikiword"));
                    break;
                }
            }
        }
    }

    private static void findBracedLinks(AnnotatedString<LinkInfo> annotatedContent) {
        for (IntegerRangeIndex.Span span : annotatedContent.spansNotInRangeList()) {
            String spanString = annotatedContent.getString(span);
            Matcher m_bracedLink = JspWikiSyntax.pattern_FIND_BRACED_LINK.matcher(spanString);
            while (m_bracedLink.find()) {
                String linkChars = m_bracedLink.group(1);
                assert (linkChars != null);
                int start = span.getStartInclusive() + m_bracedLink.start(0);
                int end = span.getStartInclusive() + m_bracedLink.end(0);
                assert (end - start >= 2);
                LinkInfo linkInfo = new LinkInfo(LinkType.ForcedBracedWikiLink);
                annotatedContent.addAnnotation(start, end - 1, (Object)linkInfo);
                String innerTokenContent = annotatedContent.getString().substring(start + 1, end - 1);
                ManualLinkFinder.defineDetailsOfBracedLink(linkInfo, innerTokenContent);
            }
        }
    }

    private static void defineDetailsOfBracedLink(LinkInfo linkInfo, String innerTokenContent) {
        linkInfo.setLinkCause(ILinkListener.LinkCause.valueOf("wikilink"));
        Matcher m_labelledLinkTarget = JspWikiSyntax.pattern_WIKILINK_TARGET_LABELED.matcher(innerTokenContent);
        if (m_labelledLinkTarget.matches()) {
            linkInfo.setLinkText(m_labelledLinkTarget.group(1));
            linkInfo.setLinkTargetName(m_labelledLinkTarget.group(2));
        } else {
            linkInfo.setLinkText(innerTokenContent);
            linkInfo.setLinkTargetName(innerTokenContent);
        }
        if (linkInfo.getLinkText().trim().length() == 0) {
            linkInfo.setProblem("Encountered linkText '" + linkInfo.getLinkText() + "' which is just white-space. Ignored.");
            return;
        }
        if (JspWikiSyntax.isFootnote((String)linkInfo.getLinkTargetName())) {
            linkInfo.setProblem("Skip link which represents just an old JSPWiki footnote");
            return;
        }
        if (JspWikiSyntax.isPluginCall((String)linkInfo.getLinkTargetName())) {
            linkInfo.setProblem("Skip link which represents a JSPWiki plugin call");
            return;
        }
        if (!JspWikiSyntax.isHttpLink((String)linkInfo.getLinkTargetName()) && !JspWikiSyntax.isFileLink((String)linkInfo.getLinkTargetName())) {
            if (JspWikiSyntax.pattern_PARTIAL_URL.matcher(linkInfo.getLinkTargetName()).matches()) {
                linkInfo.setLinkTargetName("http://" + linkInfo.getLinkTargetName());
            } else if (JspWikiSyntax.pattern_EMAIL.matcher(linkInfo.getLinkTargetName()).matches()) {
                if (!linkInfo.getLinkTargetName().startsWith("mailto:")) {
                    linkInfo.setLinkTargetName("mailto:" + linkInfo.getLinkTargetName());
                }
            } else if (!JspWikiSyntax.pattern_WIKILINK_TARGET.matcher(linkInfo.getLinkTargetName()).matches()) {
                log.warn("Unhandled link linkText='" + linkInfo.getLinkText() + "' target='" + linkInfo.getLinkTargetName() + "'");
                return;
            }
        }
        assert (linkInfo.getLinkTargetName() != null);
    }
}

