/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import de.xam.texthtml.html.SharedHtmlUtils;

public class TextRenderer {
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final String SCHEMES = "(http|https)";
    public static final String SCHEME = "(?:(http|https):\\/\\/)";
    public static final String SUBDOMAIN = "(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+";
    public static final String TOPLEVELDOMAIN = "(?:[a-z]{2,}|[A-Z]{2,})";
    public static final String DOMAIN = "(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)";
    public static final String REGEX_MINIMAL_URL_CONTAINS = "[:.]|localhost";
    public static final String PORT = "(?::[0-9]+)?";
    public static final String LEGAL_URL_CHARS_IN_PATH_OR_FRAGMENT = "a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-";
    public static final String LEGAL_URL_CHARS = "a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#?";
    public static final String URL_PATH_OR_FRAGMENT_PART = "(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))";
    public static final String FRAGMENT = "(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?";
    public static final String PATH = "(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?";
    public static final String FULL_HTTP_URL = "(?:(?:(http|https):\\/\\/)(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)";
    public static final String FILE_URL = "(?:file:\\/\\/(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)";
    public static final String PARTIAL_URL = "(?:(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)";
    private static final String EMAIL_BEFORE_AT = "(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF._~!$&()*+;=:-]+)";
    public static final String EMAIL = "(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF._~!$&()*+;=:-]+)@(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost))";
    public static final String WHITESPACE = "[ \\t\\n\\r]";
    public static final String FIND_HTTP_URL = TextRenderer.findRegex("(?:(?:(http|https):\\/\\/)(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)", true, '(', ')');
    public static final String FIND_FILE_URL = TextRenderer.findRegex("(?:file:\\/\\/(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)", false, 'x', 'x');
    public static final String FIND_EMAIL = TextRenderer.findRegex("(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF._~!$&()*+;=:-]+)@(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost))", true, '<', '>');
    public static final String FIND_PARTIAL_URL = TextRenderer.findRegex("(?:(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)", true, '(', ')');

    public static final String findRegex(String baseRegex, boolean allowBraced, char openBrace, char closeBrace) {
        String x = "";
        x = x + "(?:";
        x = x + "(^|[ \\t\\n\\r])(" + baseRegex + ")" + "(" + WHITESPACE + "|$)" + ")";
        if (allowBraced) {
            x = x + "|(?:([" + openBrace + "])" + "(" + baseRegex + ")" + "([" + closeBrace + "])" + ")";
        }
        return x;
    }

    public static String renderAsSafeHtml(String plainText) {
        String safe;
        if (plainText == null) {
            return null;
        }
        String linked = safe = SharedHtmlUtils.htmlEncode(plainText);
        try {
            linked = linked.replaceAll(FIND_HTTP_URL, "$1$4<a target=\"_blank\" class=\"full auto\" href=\"$2$5\">$2$5</a>$3$6");
            linked = linked.replaceAll(FIND_FILE_URL, "$1$4<a target=\"_blank\" class=\"file auto\" href=\"$2$5\">$2$5</a>$3$6");
            linked = linked.replaceAll(FIND_PARTIAL_URL, "$1$4<a target=\"_blank\" class=\"partial auto\" href=\"http://$2$5\">$2$5</a>$3$6");
        }
        catch (Exception e) {
            throw new RuntimeException("Error rendering '" + plainText + "'", e);
        }
        return linked;
    }
}

