/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader;

import java.io.File;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ResourceClasspathScanner {
    private static final Logger log = LoggerFactory.getLogger(ResourceClasspathScanner.class);

    public static List<String> findRessources(String regex) {
        ArrayList<String> classes = new ArrayList<String>();
        for (File location : ResourceClasspathScanner.getClasspathLocations()) {
            log.info("Scanning " + location.getAbsolutePath());
            try {
                boolean existsAndAccessAllowed = false;
                try {
                    existsAndAccessAllowed = location.exists();
                }
                catch (AccessControlException e) {
                    log.warn("No access to " + location.getAbsolutePath());
                }
                if (!existsAndAccessAllowed) continue;
                if (location.isFile()) {
                    classes.addAll(ResourceClasspathScanner.scanJar(location, regex));
                    continue;
                }
                assert (location.isDirectory());
                classes.addAll(ResourceClasspathScanner.scanDirectory(location, regex));
            }
            catch (Exception e) {
                log.warn("unexpected", (Throwable)e);
            }
        }
        return classes;
    }

    public static List<File> getClasspathLocations() {
        String[] classPathElements;
        ArrayList<File> locations = new ArrayList<File>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            log.error("classPath is null. Is your ContextServlet loaded at startup?");
            return locations;
        }
        String pathSeparator = System.getProperty("path.separator");
        if (pathSeparator == null) {
            log.error("pathSeparator is null");
        }
        for (String path : classPathElements = classPath.split(pathSeparator)) {
            File f = new File(path);
            locations.add(f);
        }
        return locations;
    }

    public static List<String> scanDirectory(File dir, String regex) {
        assert (dir.isDirectory());
        ArrayList<String> matched = new ArrayList<String>();
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                String path = f.getAbsolutePath();
                if (!path.matches(regex)) continue;
                matched.add(path);
                continue;
            }
            assert (f.isDirectory());
            matched.addAll(ResourceClasspathScanner.scanDirectory(f, regex));
        }
        return matched;
    }

    public static List<String> scanJar(File jarFile, String ressourceRegex) {
        ArrayList<String> matched = new ArrayList<String>();
        if (!jarFile.getName().endsWith(".jar")) {
            return matched;
        }
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.matches(ressourceRegex)) continue;
                matched.add(name);
            }
            jar.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return matched;
    }
}

