/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader.p13n.time;

import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.p13n.shared.time.TzDatabase;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.xydra.env.Env;

public class TimeZoneUtils {
    public static final short DEFAULT_SAN_FRANCISCO = -7;
    public static final short GERMANY = 1;

    public static int guessTimezoneOffset(MiniLocale locale) {
        assert (locale != null);
        if (locale.getCountry().equals(MiniLocale.EN_US.getCountry())) {
            return -7;
        }
        Set set = TzDatabase.getEntriesForCountryCode((String)locale.getCountry());
        if (set.size() == 1) {
            String timeZoneName = ((TzDatabase.TzEntry)set.iterator().next()).zoneName;
            DateTimeZone dateTimeZone = DateTimeZone.forID((String)timeZoneName);
            return dateTimeZone.getStandardOffset(TimeProvider.getCurrentTimeInMillis());
        }
        return ((Personalisation)Env.get().conf().getAs("resource-p13n", Personalisation.class)).getUtcOffset();
    }
}

