/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae;

import java.util.Map;
import org.xydra.base.XId;
import org.xydra.gae.admin.GaeConfiguration;
import org.xydra.gae.admin.GaeConfigurationManager;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.XydraPersistence;
import org.xydra.store.XydraConfigUtils;
import org.xydra.store.XydraPlatformRuntime;
import org.xydra.store.XydraRuntime;
import org.xydra.store.impl.gae.GaePersistence;
import org.xydra.store.impl.gae.InstanceContext;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.xgae.XGae;

public class GaePlatformRuntime
implements XydraPlatformRuntime {
    private static final Logger log = LoggerFactory.getLogger(GaePlatformRuntime.class);

    public XydraPersistence createPersistence(XId repositoryId) {
        log.info("INIT XydraPersistence instance with id '" + repositoryId + "'.");
        return new GaePersistence(repositoryId);
    }

    public void finishRequest() {
        log.info("Request finished.");
    }

    public void startRequest() {
        log.info("Request started.");
    }

    public String getName() {
        return "GAE-" + XGae.get().inModeAsString();
    }

    static {
        log.info("Configuring default gae conf");
        GaeConfiguration defaultConf = GaeConfigurationManager.getDefaultConfiguration();
        defaultConf.map().put("assert", "true");
        defaultConf.map().put("usememcache", "true");
        defaultConf.map().put("memcacheStats", "");
        defaultConf.map().put("persistenceStats", "");
        XydraRuntime.addStaticListener((XydraRuntime.Listener)new XydraRuntime.Listener(){

            public void onXydraRuntimeInit() {
                boolean usememcache = XydraRuntime.getConfigMap().get("usememcache") != null;
                Memcache.setUseMemCache(usememcache);
            }
        });
        GaeConfigurationManager.addListener(new GaeConfigurationManager.Listener(){

            @Override
            public void onChange(GaeConfiguration conf) {
                boolean requiresRuntimeInit = false;
                Map changes = XydraConfigUtils.getChanges((Map)XydraRuntime.getConfigMap(), conf.map());
                for (String key : changes.keySet()) {
                    String value = XydraConfigUtils.normalizeValue((String)((String)changes.get(key)));
                    if (value.equals("")) {
                        log.info("Instance conf: remove key '" + key + "'");
                        XydraRuntime.getConfigMap().remove(key);
                    } else {
                        log.info("Instance conf: set key '" + key + "' = '" + value + "'");
                        XydraRuntime.getConfigMap().put(key, value);
                        this.handleClearLocalVmCache(key, value);
                    }
                    requiresRuntimeInit |= key.equals("memcacheStats");
                    requiresRuntimeInit |= key.equals("persistenceStats");
                    requiresRuntimeInit |= key.equals("useMemcacheInPersistenceImpl");
                }
                if (requiresRuntimeInit) {
                    log.info("Changes require a XydraRuntime re-init");
                    InstanceContext.clear();
                    XydraRuntime.forceReInitialisation();
                }
            }

            private void handleClearLocalVmCache(String key, String value) {
                long clearRequested;
                if (!key.equals("clearvmcache")) {
                    return;
                }
                assert (value != null);
                assert (!value.equals(""));
                String lastExecutedStr = (String)XydraRuntime.getConfigMap().get("clearvmcache_executed");
                long lastExecuted = lastExecutedStr == null ? 0L : Long.parseLong(lastExecutedStr);
                if (lastExecuted < (clearRequested = Long.parseLong(value))) {
                    log.info("clearLocalVmCache requested with Nr. " + clearRequested + " lastExecuted: " + lastExecuted);
                    InstanceContext.clear();
                    XydraRuntime.getConfigMap().put("clearvmcache_executed", "" + clearRequested);
                } else {
                    log.info("No clearLocalVmCache necessary. lastExecuted = " + lastExecuted);
                }
            }
        });
    }
}

