/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.changes;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.XType;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.XTransactionEvent;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.persistence.ModelRevision;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.InstanceRevisionManager;
import org.xydra.store.impl.gae.Memcache;
import org.xydra.store.impl.gae.UniCache;
import org.xydra.store.impl.gae.changes.AllChanges;
import org.xydra.store.impl.gae.changes.CandidateRev;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.changes.GaeEvents;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.GaeModelRevision;
import org.xydra.store.impl.gae.changes.IGaeChangesService;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.changes.RevisionInfo;
import org.xydra.store.impl.gae.changes.UniCacheRevisionInfoEntryHandler;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.CapabilityDisabledException;
import org.xydra.xgae.datastore.api.CommittedButStillApplyingException;
import org.xydra.xgae.datastore.api.DatastoreFailureException;
import org.xydra.xgae.datastore.api.DatastoreTimeoutException;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.STransaction;

public class GaeChangesServiceImpl3
implements IGaeChangesService {
    private static final Logger log = LoggerFactory.getLogger(GaeChangesServiceImpl3.class);
    private static final String KEY_CACHE_REVINFO = "revInfo";
    private static final UniCacheRevisionInfoEntryHandler uniCacheRevisionInfoEntryHandler = new UniCacheRevisionInfoEntryHandler();
    private static final boolean USE_MEMCACHE_FOR_CHANGES = false;
    private static final boolean USE_MEMCACHE_FOR_REVISIONS = false;
    private static final int OFFSET = (int)(Math.random() * 16.0);
    private static final int[] WINDOW_SIZES = new int[]{1, 8, 32, 128};
    private RevisionInfo revInfoFromMemcacheAndDatastore = null;
    private final XAddress modelAddr;
    private final InstanceRevisionManager instanceRevInfoManager;
    private final UniCache<RevisionInfo> revInfoMemcacheAndDatastoreCache;
    private final AllChanges cachedChanges;
    private final String revisionCacheName;

    @Override
    public XAddress getModelAddress() {
        return this.modelAddr;
    }

    private static boolean eventIndicatesModelExists(XEvent e) {
        XyAssert.xyAssert((e != null ? 1 : 0) != 0);
        assert (e != null);
        XEvent event = e;
        if (event.getChangeType() == ChangeType.TRANSACTION) {
            XTransactionEvent txnEvent = (XTransactionEvent)event;
            XyAssert.xyAssert((txnEvent.size() >= 1 ? 1 : 0) != 0);
            event = txnEvent.getEvent(txnEvent.size() - 1);
            XyAssert.xyAssert((event != null ? 1 : 0) != 0);
            assert (event != null);
        }
        XyAssert.xyAssert((event.getChangeType() != ChangeType.TRANSACTION ? 1 : 0) != 0);
        return event.getTarget().getAddressedType() != XType.XREPOSITORY || event.getChangeType() != ChangeType.REMOVE;
    }

    private static boolean eventsAreWithinRange(List<XEvent> events, long begin, long endRev) {
        for (XEvent e : events) {
            XyAssert.xyAssert((e.getRevisionNumber() >= begin ? 1 : 0) != 0);
            XyAssert.xyAssert((e.getRevisionNumber() <= endRev ? 1 : 0) != 0);
        }
        return true;
    }

    private static int windowsSizeForRound(int round) {
        XyAssert.xyAssert((round >= 0 ? 1 : 0) != 0);
        XyAssert.xyAssert((WINDOW_SIZES.length > 0 ? 1 : 0) != 0);
        if (round < WINDOW_SIZES.length) {
            return WINDOW_SIZES[round];
        }
        return WINDOW_SIZES[WINDOW_SIZES.length - 1];
    }

    public GaeChangesServiceImpl3(XAddress modelAddr, InstanceRevisionManager revisionManager) {
        this.modelAddr = modelAddr;
        this.instanceRevInfoManager = revisionManager;
        this.cachedChanges = new AllChanges(modelAddr);
        this.revisionCacheName = KEY_CACHE_REVINFO + modelAddr;
        this.revInfoMemcacheAndDatastoreCache = new UniCache<RevisionInfo>(uniCacheRevisionInfoEntryHandler);
    }

    @Override
    public GaeModelRevision calculateCurrentModelRevision(boolean includeTentative) {
        GaeModelRevision lastCurrentRev = this.instanceRevInfoManager.getInstanceRevisionInfo().getGaeModelRevision();
        XyAssert.xyAssert((lastCurrentRev.getModelRevision() != null ? 1 : 0) != 0);
        log.info(this.getModelAddress() + " >> Update currentRev from lastCurrentRev=" + lastCurrentRev);
        CandidateRev candidate = new CandidateRev(lastCurrentRev);
        XyAssert.xyAssert((!candidate.isFinalModelRev() ? 1 : 0) != 0, (Object)"we cannot know this yet");
        int round = 0;
        long eventsLoadedBeforeRevInfoLookupInBackend = 0L;
        boolean askedMemcacheOrDatastore = false;
        long lastCheckedRev = lastCurrentRev.getLastSilentCommitted();
        log.debug("Start searching at " + lastCheckedRev + " with last rev being " + candidate.gaeModelRev.getModelRevision());
        while (true) {
            if (!askedMemcacheOrDatastore && eventsLoadedBeforeRevInfoLookupInBackend > 0L) {
                log.info("Asking cache after " + eventsLoadedBeforeRevInfoLookupInBackend + " attempts");
                RevisionInfo revInfoFromMemcacheOrDatastore = this.revInfoMemcacheAndDatastoreCache.get(this.revisionCacheName, UniCache.StorageOptions.create(0, false, true, false));
                if (revInfoFromMemcacheOrDatastore != null) {
                    this.revInfoFromMemcacheAndDatastore = revInfoFromMemcacheOrDatastore;
                    ModelRevision cachedModelRev = revInfoFromMemcacheOrDatastore.getGaeModelRevision().getModelRevision();
                    if (cachedModelRev != null && cachedModelRev.revision() > candidate.gaeModelRev.getModelRevision().revision()) {
                        candidate.gaeModelRev = revInfoFromMemcacheOrDatastore.getGaeModelRevision();
                        XyAssert.xyAssert((revInfoFromMemcacheOrDatastore.getLastCommitted() > lastCheckedRev ? 1 : 0) != 0);
                        lastCheckedRev = revInfoFromMemcacheOrDatastore.getLastCommitted();
                        XyAssert.xyAssert((lastCheckedRev >= candidate.gaeModelRev.getModelRevision().revision() ? 1 : 0) != 0);
                        round = 0;
                        log.debug("Cached value is a better start than what we had. Now using " + candidate.gaeModelRev);
                    }
                }
                askedMemcacheOrDatastore = true;
                XyAssert.xyAssert((!candidate.isFinalModelRev() ? 1 : 0) != 0);
            }
            int windowSize = GaeChangesServiceImpl3.windowsSizeForRound(round);
            log.debug("Windowsize = " + windowSize);
            long beginRevInclusive = lastCheckedRev + 1L;
            long endRevInclusive = beginRevInclusive + (long)windowSize - 1L;
            log.debug(this.modelAddr + ":: Update rev step [" + beginRevInclusive + "," + endRevInclusive + "]");
            log.debug("=== Phase 1: Determine revisions not yet locally cached; windowsize = " + windowSize);
            Set<Long> locallyMissingRevs = this.computeLocallyMissingRevs(beginRevInclusive, endRevInclusive);
            int missingRevs = locallyMissingRevs.size();
            log.trace("locallyMissingRevs: " + missingRevs + " in this window of " + (endRevInclusive - beginRevInclusive + 1L) + " revs in total");
            log.debug("=== Phase 2+3: Ask Memcache + Datastore ===");
            long queryTime = this.fetchMissingRevisionsFromMemcacheAndDatastore(locallyMissingRevs);
            int fetchedRevs = missingRevs - locallyMissingRevs.size();
            log.trace("Number of missingRevs after asking DS&MC: " + locallyMissingRevs.size());
            log.debug("=== Phase 4: Compute result from local cache ===");
            candidate = this.computeCurrenRevisionFromLocalChanges(beginRevInclusive, endRevInclusive, candidate, includeTentative);
            if (candidate.finalModelRev) {
                long rev = candidate.gaeModelRev.getModelRevision().revision();
                log.info(this.modelAddr + ">> Computed rev = " + rev + " DATA?changesMethod=calculateCurrentModelRevision" + "&i_type=rev" + "&i_addr=" + this.modelAddr + "&rev=" + candidate.gaeModelRev.getModelRevision().revision() + "&tentative=" + candidate.gaeModelRev.getModelRevision().tentativeRevision() + "&window=" + windowSize + "&instance=" + XGae.get().getInstanceId() + "&queryAge=" + (System.nanoTime() - queryTime));
                return candidate.gaeModelRev;
            }
            lastCheckedRev = endRevInclusive;
            eventsLoadedBeforeRevInfoLookupInBackend += (long)fetchedRevs;
            ++round;
        }
    }

    public void clear() {
        log.info("Cleared. Make to sure to also clear memcache.");
        this.instanceRevInfoManager.getInstanceRevisionInfo().clear();
    }

    @Override
    public void commit(GaeChange change, GaeChange.Status status) {
        XyAssert.xyAssert((boolean)status.isCommitted());
        XyAssert.xyAssert((!change.getStatus().isCommitted() ? 1 : 0) != 0);
        change.commitAndClearLocks(status);
        XyAssert.xyAssert((change.getStatus() == status ? 1 : 0) != 0);
        this.cacheCommittedChange(change);
        log.trace(" DATA?changesMethod=commit&i_type=rev&i_addr=" + this.modelAddr + "&rev=" + change.rev + "&status=" + (Object)((Object)change.getStatus()) + "&instance=" + XGae.get().getInstanceId());
    }

    private CandidateRev computeCurrenRevisionFromLocalChanges(long beginRevInclusive, long endRevInclusive, CandidateRev candidate, boolean includeTentative) {
        XyAssert.xyAssert((!candidate.isFinalModelRev() ? 1 : 0) != 0);
        XyAssert.xyAssert((candidate.gaeModelRev.getModelRevision() != null ? 1 : 0) != 0);
        XyAssert.xyAssert((endRevInclusive - beginRevInclusive >= 0L ? 1 : 0) != 0, (Object)("begin:" + beginRevInclusive + ",end:" + endRevInclusive));
        log.debug(this.modelAddr + ":: computeFromCache candidate=" + candidate + " in range [" + beginRevInclusive + "," + endRevInclusive + "]");
        for (long i = beginRevInclusive; i <= endRevInclusive; ++i) {
            boolean putInDatastore;
            GaeChange change = this.cachedChanges.getCachedChange(i);
            if (change == null) {
                log.debug("Found end at " + i + " return workingRev=" + candidate);
                candidate.markAsFinalRev();
            } else if (change.getStatus().isCommitted()) {
                candidate.gaeModelRev.setLastSilentCommittedIfHigher(i);
                if (change.getStatus().changedSomething()) {
                    XEvent event = change.getEvent();
                    boolean modelExist = GaeChangesServiceImpl3.eventIndicatesModelExists(event);
                    if (candidate.inTentativeRange) {
                        candidate.setModelRev(new GaeModelRevision(candidate.gaeModelRev.getLastSilentCommitted(), new ModelRevision(candidate.gaeModelRev.getModelRevision().revision(), modelExist, i)));
                    } else {
                        candidate.setModelRev(new GaeModelRevision(event.getRevisionNumber(), new ModelRevision(i, modelExist)));
                    }
                    log.debug(this.modelAddr + ":: New currentRev candidate " + candidate);
                }
            } else {
                XyAssert.xyAssert((!change.getStatus().isCommitted() ? 1 : 0) != 0);
                if (!includeTentative) {
                    log.debug("Found end at " + i + " return workingRev=" + candidate);
                    candidate.markAsFinalRev();
                }
            }
            if (i % 16L == 4L) {
                // empty if block
            }
            boolean putInMemcache = false;
            boolean bl = putInDatastore = i % 64L == (long)OFFSET;
            if (putInMemcache || putInDatastore) {
                RevisionInfo toBeCached;
                UniCache.StorageOptions storeOpts = UniCache.StorageOptions.create(0, putInMemcache, putInDatastore, false);
                if (this.revInfoFromMemcacheAndDatastore == null) {
                    this.revInfoFromMemcacheAndDatastore = this.revInfoMemcacheAndDatastoreCache.get(this.revisionCacheName, storeOpts);
                }
                if ((toBeCached = new RevisionInfo("toBeCached", candidate.gaeModelRev, this.instanceRevInfoManager.getInstanceRevisionInfo().getLastCommitted(), this.instanceRevInfoManager.getInstanceRevisionInfo().getLastTaken())).isBetterThan(this.revInfoFromMemcacheAndDatastore)) {
                    log.debug("this revInfo " + toBeCached + " is better than " + this.revInfoFromMemcacheAndDatastore + " and thus will be cached");
                    try {
                        this.revInfoMemcacheAndDatastoreCache.put(this.revisionCacheName, toBeCached, storeOpts);
                    }
                    catch (CapabilityDisabledException err) {
                        log.warn("Could not write", (Throwable)err);
                    }
                }
            }
            if (!candidate.finalModelRev) continue;
            if (includeTentative) {
                GaeModelRevision g = candidate.gaeModelRev;
                ModelRevision mr = g.getModelRevision();
                candidate.gaeModelRev = new GaeModelRevision(g.getLastSilentCommitted(), new ModelRevision(mr.revision(), mr.modelExists(), mr.revision()));
            }
            this.instanceRevInfoManager.getInstanceRevisionInfo().setCurrentGaeModelRevIfRevisionIsHigher(candidate.gaeModelRev);
            log.debug("Updated rev to " + candidate.gaeModelRev);
            return candidate;
        }
        XyAssert.xyAssert((!candidate.finalModelRev ? 1 : 0) != 0);
        return candidate;
    }

    private Set<Long> computeLocallyMissingRevs(long startRevInclusive, long endRevInclusive) {
        log.debug("computeLocallyMissingRevs [" + startRevInclusive + "," + endRevInclusive + "]");
        HashSet<Long> locallyMissingRevs = new HashSet<Long>();
        for (long i = startRevInclusive; i <= endRevInclusive; ++i) {
            GaeChange change = this.cachedChanges.getCachedChange(i);
            if (change == null) {
                locallyMissingRevs.add(i);
                continue;
            }
            XyAssert.xyAssert((change.rev == i ? 1 : 0) != 0);
            if (change.getStatus().isCommitted()) continue;
            locallyMissingRevs.add(i);
        }
        return locallyMissingRevs;
    }

    private long fetchMissingRevisionsFromDatastore(Set<Long> locallyMissingRevs) {
        XyAssert.xyAssert((locallyMissingRevs != null ? 1 : 0) != 0);
        assert (locallyMissingRevs != null);
        XyAssert.xyAssert((!locallyMissingRevs.isEmpty() ? 1 : 0) != 0);
        ArrayList<SKey> datastoreBatchRequest = new ArrayList<SKey>(locallyMissingRevs.size());
        for (Long l : locallyMissingRevs) {
            SKey key = KeyStructure.createChangeKey(this.getModelAddress(), l);
            datastoreBatchRequest.add(key);
        }
        long queryTime = System.nanoTime();
        Map datastoreResult = XGae.get().datastore().sync().getEntities(datastoreBatchRequest);
        HashMap<String, SEntity> memcacheBatchPut = new HashMap<String, SEntity>();
        long newLastTaken = -1L;
        for (Map.Entry entry : datastoreResult.entrySet()) {
            SKey key = (SKey)entry.getKey();
            SEntity entity = (SEntity)entry.getValue();
            XyAssert.xyAssert((entity != null ? 1 : 0) != 0);
            XyAssert.xyAssert((entity != Memcache.NULL_ENTITY ? 1 : 0) != 0);
            long revFromKey = KeyStructure.getRevisionFromChangeKey(key);
            GaeChange change = new GaeChange(this.getModelAddress(), revFromKey, entity);
            GaeChange.Status status = change.getStatus();
            if (status.canChange()) {
                try {
                    this.progressChange(change);
                }
                catch (CapabilityDisabledException err) {
                    log.warn("Could not progress change", (Throwable)err);
                }
                if (change.getStatus() != GaeChange.Status.FailedTimeout) {
                    log.debug("Change " + change.rev + " is being worked on by another 'thread', left untouched");
                }
                if (change.rev > newLastTaken) {
                    newLastTaken = change.rev;
                }
            }
            if (status.isCommitted()) {
                log.debug("Found in datastore, comitted " + change.rev);
                memcacheBatchPut.put(KeyStructure.toString(key), entity);
                locallyMissingRevs.remove(revFromKey);
            }
            this.cacheChange(change);
            log.trace("Got change from DS " + (Object)((Object)change.getStatus()) + " timeout?" + change.isTimedOut() + ". Dump: " + change + " ||| Now = " + System.currentTimeMillis() + " DATA:changesMethod=fetchMissingRevisionsFromDatastore" + "&i_addr=" + this.getModelAddress() + "&rev=" + change.rev + "&instance=" + XGae.get().getInstanceId() + "&status=" + (Object)((Object)change.getStatus()));
        }
        if (newLastTaken >= 0L) {
            this.instanceRevInfoManager.getInstanceRevisionInfo().setLastTakenIfHigher(newLastTaken);
        }
        return queryTime;
    }

    private void fetchMissingRevisionsFromMemcache(Set<Long> locallyMissingRevs) {
        SKey key;
        XyAssert.xyAssert((locallyMissingRevs != null ? 1 : 0) != 0);
        assert (locallyMissingRevs != null);
        XyAssert.xyAssert((!locallyMissingRevs.isEmpty() ? 1 : 0) != 0);
        ArrayList<String> memcacheBatchRequest = new ArrayList<String>(locallyMissingRevs.size());
        for (long askRev : locallyMissingRevs) {
            key = KeyStructure.createChangeKey(this.getModelAddress(), askRev);
            memcacheBatchRequest.add(KeyStructure.toString(key));
        }
        Map<String, Object> memcacheResult = Memcache.getEntities(memcacheBatchRequest);
        for (Map.Entry<String, Object> entry : memcacheResult.entrySet()) {
            key = KeyStructure.toKey(entry.getKey());
            Object v = entry.getValue();
            XyAssert.xyAssert((v != null ? 1 : 0) != 0, (Object)"v!=null");
            assert (v != null);
            assert (v instanceof SEntity) : v.getClass();
            SEntity entity = (SEntity)v;
            XyAssert.xyAssert((!entity.equals(Memcache.NULL_ENTITY) ? 1 : 0) != 0, (Object)("" + key));
            long rev = KeyStructure.getRevisionFromChangeKey(key);
            GaeChange change = new GaeChange(this.getModelAddress(), rev, entity);
            XyAssert.xyAssert((change.getStatus() != null ? 1 : 0) != 0);
            XyAssert.xyAssert((boolean)change.getStatus().isCommitted(), (Object)(change.rev + " " + (Object)((Object)change.getStatus())));
            this.cacheCommittedChange(change);
            locallyMissingRevs.remove(change.rev);
            log.trace("Found in memcache " + change.rev);
        }
    }

    private long fetchMissingRevisionsFromMemcacheAndDatastore(Set<Long> locallyMissingRevs) {
        XyAssert.xyAssert((locallyMissingRevs != null ? 1 : 0) != 0);
        assert (locallyMissingRevs != null);
        if (locallyMissingRevs.isEmpty()) {
            log.debug("No revisions are missing, nothing to fetch from memcache/datastore");
            return -1L;
        }
        return this.fetchMissingRevisionsFromDatastore(locallyMissingRevs);
    }

    @Override
    public GaeChange getChange(long rev) {
        GaeChange change = this.cachedChanges.getCachedChange(rev);
        if (change != null) {
            return change;
        }
        SKey key = KeyStructure.createChangeKey(this.modelAddr, rev);
        SEntity entityFromGae = XGae.get().datastore().sync().getEntity(key);
        if (entityFromGae == null) {
            return null;
        }
        change = new GaeChange(this.modelAddr, rev, entityFromGae);
        this.cacheChange(change);
        return change;
    }

    @Override
    public List<XEvent> getEventsBetween(XAddress address, long beginRevision, long endRevision) {
        log.debug("getEventsBetween [" + beginRevision + "," + endRevision + "] @" + this.getModelAddress());
        if (beginRevision < 0L) {
            throw new IndexOutOfBoundsException("beginRevision is not a valid revision number, was " + beginRevision);
        }
        if (endRevision < 0L) {
            throw new IndexOutOfBoundsException("endRevision is not a valid revision number, was " + endRevision);
        }
        if (beginRevision > endRevision) {
            throw new IllegalArgumentException("beginRevision may not be greater than endRevision");
        }
        long endRev = endRevision;
        long begin = beginRevision < 0L ? 0L : beginRevision;
        long currentRev = this.instanceRevInfoManager.getInstanceRevisionInfo().getGaeModelRevision().getModelRevision().revision();
        if (currentRev == -1L) {
            log.info("Current rev==-1, return null from " + currentRev);
            return null;
        }
        if (beginRevision > currentRev) {
            return new ArrayList<XEvent>(0);
        }
        if (endRev > currentRev) {
            endRev = currentRev;
        }
        log.debug("Adjusted range [" + begin + "," + endRev + "]");
        ArrayList<XEvent> events = new ArrayList<XEvent>();
        Set<Long> locallyMissingRevs = this.computeLocallyMissingRevs(begin, endRev);
        this.fetchMissingRevisionsFromMemcacheAndDatastore(locallyMissingRevs);
        for (long i = begin; i <= endRev; ++i) {
            log.debug("Trying to find & apply event " + i);
            GaeChange change = this.cachedChanges.getCachedChange(i);
            if (change != null) {
                XyAssert.xyAssert((!change.getStatus().canChange() ? 1 : 0) != 0, (Object)((Object)change.getStatus()));
                if (change.getStatus().changedSomething()) {
                    log.debug("Change " + i + " rev=" + change.rev + " is successful");
                    XEvent event = change.getEvent();
                    XyAssert.xyAssert((event != null ? 1 : 0) != 0, (Object)change);
                    events.add(event);
                    continue;
                }
                XyAssert.xyAssert((boolean)change.getStatus().canChange());
                log.debug("Change " + i + " is " + change.getStatus().name());
                continue;
            }
            log.warn("==== Change " + i + " is null, was asking [" + begin + "," + endRev + "]. Retry. Current rev = " + this.instanceRevInfoManager.getInstanceRevisionInfo().getGaeModelRevision().getModelRevision());
            throw new RuntimeException("Encountered null-change at " + i);
        }
        XyAssert.xyAssert((boolean)GaeChangesServiceImpl3.eventsAreWithinRange(events, begin, endRev));
        return events;
    }

    @Override
    public GaeEvents.AsyncValue getValue(long rev, int transindex) {
        int realindex;
        GaeChange change = this.cachedChanges.getCachedChange(rev);
        if (change != null && (realindex = GaeEvents.getEventIndex(transindex)) >= 0) {
            XEvent event = change.getEvent();
            if (event instanceof XTransactionEvent) {
                XyAssert.xyAssert((((XTransactionEvent)event).size() > realindex ? 1 : 0) != 0);
                event = ((XTransactionEvent)event).getEvent(realindex);
            } else {
                XyAssert.xyAssert((realindex == 0 ? 1 : 0) != 0);
            }
            XyAssert.xyAssert((boolean)(event instanceof XFieldEvent));
            return new GaeEvents.AsyncValue(((XFieldEvent)event).getNewValue());
        }
        return GaeEvents.getValue(this.modelAddr, rev, transindex);
    }

    @Override
    public GaeChange grabRevisionAndRegisterLocks(long lastTaken, GaeLocks locks, XId actorId) {
        long start;
        XyAssert.xyAssert((lastTaken >= -1L ? 1 : 0) != 0);
        long rev = start = lastTaken + 1L;
        while (true) {
            block9: {
                GaeChange cachedChange;
                if ((cachedChange = this.cachedChanges.getCachedChange(rev)) == null) {
                    SKey key = KeyStructure.createChangeKey(this.modelAddr, rev);
                    STransaction trans = XGae.get().datastore().sync().beginTransaction();
                    SEntity changeEntity = XGae.get().datastore().sync().getEntity(key, trans);
                    if (changeEntity == null) {
                        GaeChange newChange = new GaeChange(this.modelAddr, rev, locks, actorId);
                        newChange.save(trans);
                        try {
                            XGae.get().datastore().sync().endTransaction(trans);
                        }
                        catch (ConcurrentModificationException cme) {
                            log.info("ConcurrentModificationException, failed to take revision: " + key, (Throwable)cme);
                            --rev;
                            break block9;
                        }
                        catch (DatastoreTimeoutException dte) {
                            log.warn("DatastoreTimeout");
                            log.info("failed to take revision: " + key, (Throwable)dte);
                            --rev;
                            break block9;
                        }
                        catch (DatastoreFailureException dfe) {
                            log.warn("DatastoreFailureException on " + key);
                            log.info("failed to take revision: " + key, (Throwable)dfe);
                            --rev;
                            break block9;
                        }
                        catch (CommittedButStillApplyingException csa) {
                            log.warn("CommittedButStillApplyingException on " + key);
                            break block9;
                        }
                        this.instanceRevInfoManager.getInstanceRevisionInfo().setLastTakenIfHigher(rev);
                        this.computeCurrenRevisionFromLocalChanges(start, rev, new CandidateRev(new GaeModelRevision(rev, this.instanceRevInfoManager.getInstanceRevisionInfo().getGaeModelRevision().getModelRevision())), false);
                        return newChange;
                    }
                    GaeChange change = new GaeChange(this.modelAddr, rev, changeEntity);
                    XGae.get().datastore().sync().endTransaction(trans);
                    this.instanceRevInfoManager.getInstanceRevisionInfo().setLastTakenIfHigher(rev);
                    GaeChange.Status status = change.getStatus();
                    if (!status.isCommitted()) {
                        this.progressChange(change);
                    }
                    this.cacheChange(change);
                }
            }
            ++rev;
        }
    }

    @Override
    public boolean modelHasBeenManaged() {
        GaeChange change = this.getChange(0L);
        return change != null;
    }

    private void progressChange(GaeChange change) {
        log.debug("Progressing change " + change);
        if (change.isTimedOut()) {
            log.debug("handleTimeout: " + change);
            this.commit(change, GaeChange.Status.FailedTimeout);
        }
    }

    @Override
    public void cacheCommittedChange(GaeChange change) {
        XyAssert.xyAssert((boolean)change.getStatus().isCommitted());
        this.cachedChanges.cacheCommittedChange(change);
        this.instanceRevInfoManager.getInstanceRevisionInfo().setLastCommittedIfHigher(change.rev);
    }

    private void cacheChange(GaeChange change) {
        if (change.getStatus().isCommitted()) {
            this.cacheCommittedChange(change);
        } else {
            this.cachedChanges.cacheCommittedChange(change);
        }
    }
}

