/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.store.impl.gae.ng;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.xydra.annotations.Setting;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.XEvent;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.gae.changes.GaeChange;
import org.xydra.store.impl.gae.changes.GaeLocks;
import org.xydra.store.impl.gae.changes.KeyStructure;
import org.xydra.store.impl.gae.ng.GaeModelPersistenceNG;
import org.xydra.store.impl.gae.ng.Interval;
import org.xydra.store.impl.gae.ng.RevisionManager;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.CommittedButStillApplyingException;
import org.xydra.xgae.datastore.api.DatastoreFailureException;
import org.xydra.xgae.datastore.api.DatastoreTimeoutException;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.STransaction;

public class ChangeLogManager {
    private static final Logger log = LoggerFactory.getLogger(ChangeLogManager.class);
    @Setting(value="")
    static final int MAXIMAL_CHANGES_FETCH_SIZE = 256;
    private final XAddress modelAddress;

    public ChangeLogManager(XAddress modelAddress) {
        XyAssert.xyAssert((modelAddress != null ? 1 : 0) != 0);
        this.modelAddress = modelAddress;
    }

    public void commitAndClearLocks(GaeChange change, GaeChange.Status status) {
        XyAssert.xyAssert((!status.canChange() ? 1 : 0) != 0);
        XyAssert.xyAssert((boolean)change.getStatus().canChange());
        change.commitAndClearLocks(status);
        XyAssert.xyAssert((change.getStatus() == status ? 1 : 0) != 0);
    }

    public GaeChange getChange(long rev) {
        SKey key = KeyStructure.createChangeKey(this.modelAddress, rev);
        SEntity entityFromGae = XGae.get().datastore().sync().getEntity(key);
        if (entityFromGae == null) {
            return null;
        }
        GaeChange change = new GaeChange(this.modelAddress, rev, entityFromGae);
        return change;
    }

    private Map<Long, GaeChange> getChangesInBatch(Interval maxSingleBatchFetchRange) {
        ArrayList<SKey> keys = new ArrayList<SKey>();
        for (long rev = maxSingleBatchFetchRange.start; rev <= maxSingleBatchFetchRange.end; ++rev) {
            SKey key = KeyStructure.createChangeKey(this.modelAddress, rev);
            keys.add(key);
        }
        Map entities = XGae.get().datastore().sync().getEntities(keys);
        HashMap<Long, GaeChange> changes = new HashMap<Long, GaeChange>();
        for (Map.Entry entry : entities.entrySet()) {
            SKey key = (SKey)entry.getKey();
            long rev = KeyStructure.getRevisionFromChangeKey(key);
            SEntity entity = (SEntity)entry.getValue();
            if (entity == null) continue;
            GaeChange change = new GaeChange(this.modelAddress, rev, entity);
            changes.put(rev, change);
        }
        log.debug("BatchGet changes in " + maxSingleBatchFetchRange + " => " + changes.size() + " changes");
        return changes;
    }

    public Map<Long, GaeChange> getChanges(Interval fetchRange) {
        HashMap<Long, GaeChange> changes = new HashMap<Long, GaeChange>();
        if (!fetchRange.isEmpty()) {
            Interval singleBatchFetchRange = fetchRange.getSubInterval(256);
            boolean hadNullChanges = false;
            do {
                try {
                    Map<Long, GaeChange> newChanges = this.getChangesInBatch(singleBatchFetchRange);
                    changes.putAll(newChanges);
                    if ((long)newChanges.size() < singleBatchFetchRange.size()) {
                        hadNullChanges = true;
                    }
                }
                catch (Throwable t) {
                    log.warn("Could not read a change interval " + singleBatchFetchRange, t);
                    singleBatchFetchRange = singleBatchFetchRange.firstHalf();
                }
                singleBatchFetchRange = singleBatchFetchRange.moveRightAndShrinkToKeepEndMaxAt(fetchRange.end);
            } while (singleBatchFetchRange.end < fetchRange.end && !hadNullChanges);
        }
        return changes;
    }

    public List<XEvent> getEventsInInterval(Interval interval) {
        GaeChange change;
        log.debug("Getting events from changes in " + interval + " for " + this.modelAddress);
        LinkedList<XEvent> events = new LinkedList<XEvent>();
        Map<Long, GaeChange> changes = this.getChanges(interval);
        for (long rev = interval.start; rev <= interval.end && (change = changes.get(rev)) != null; ++rev) {
            if (!change.getStatus().changedSomething()) continue;
            events.add(change.getEvent());
        }
        log.debug("Got " + events.size() + " events from " + changes.size() + " changes in " + interval + " for " + this.modelAddress);
        return events;
    }

    public XAddress getModelAddress() {
        return this.modelAddress;
    }

    public GaeChange grabRevisionAndRegisterLocks(GaeLocks locks, XId actorId, long start, RevisionManager revisionManager) {
        long rev = start;
        while (true) {
            block7: {
                SKey key = KeyStructure.createChangeKey(this.modelAddress, rev);
                STransaction trans = XGae.get().datastore().sync().beginTransaction();
                SEntity changeEntity = XGae.get().datastore().sync().getEntity(key, trans);
                if (changeEntity == null) {
                    GaeChange newChange = new GaeChange(this.modelAddress, rev, locks, actorId);
                    newChange.save(trans);
                    try {
                        XGae.get().datastore().sync().endTransaction(trans);
                    }
                    catch (ConcurrentModificationException cme) {
                        log.info("ConcurrentModificationException, failed to take revision: " + key, (Throwable)cme);
                        --rev;
                        break block7;
                    }
                    catch (DatastoreTimeoutException dte) {
                        log.info("failed to take revision: " + key + " GA?category=error&action=DatastoreTimeout", (Throwable)dte);
                        --rev;
                        break block7;
                    }
                    catch (DatastoreFailureException dfe) {
                        log.info("failed to take revision: " + key + " GA?category=error&action=DatastoreFailureException", (Throwable)dfe);
                        --rev;
                        break block7;
                    }
                    catch (CommittedButStillApplyingException csa) {
                        log.warn("CommittedButStillApplyingException on " + key + " GA?category=error&action=CommittedButStillApplyingException");
                        break block7;
                    }
                    revisionManager.foundNewLastTaken(rev);
                    return newChange;
                }
                GaeChange change = new GaeChange(this.modelAddress, rev, changeEntity);
                XGae.get().datastore().sync().endTransaction(trans);
                revisionManager.foundNewLastTaken(rev);
                this.progressChangeIfTimedOut(change, revisionManager);
            }
            ++rev;
        }
    }

    public boolean progressChangeIfTimedOut(GaeChange change, RevisionManager revisionManager) {
        XyAssert.xyAssert((change != null ? 1 : 0) != 0);
        assert (change != null);
        GaeChange.Status status = change.getStatus();
        if (status.canChange()) {
            log.debug("Trying to progress change " + change);
            if (change.isTimedOut()) {
                log.debug("handleTimeout: " + change);
                if (status == GaeChange.Status.Creating) {
                    this.commitAndClearLocks(change, GaeChange.Status.FailedTimeout);
                    revisionManager.foundNewHigherCommitedChange(change);
                    return true;
                }
                if (status == GaeChange.Status.SuccessExecuted) {
                    Future<SKey> f = change.save();
                    try {
                        SKey key = f.get();
                        if (key != null) {
                            GaeModelPersistenceNG.rollForward_updateTentativeObjectStates(this.modelAddress, change, revisionManager.getInfo(), this);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ExecutionException e) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }
}

