/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tupleinf.impl;

import java.util.Iterator;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapIndex;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapIndex;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class SymmetricTransitiveTupleIndex {
    private static final Logger log = LoggerFactory.getLogger(SymmetricTransitiveTupleIndex.class);
    private final IMapSetIndex<XId, XId> canonical2family = new MapSetIndex((Factory)new FastEntrySetFactory());
    private final IMapIndex<XId, XId> family2canonical = new MapIndex();
    protected boolean isDirtyTransitives = false;

    public static void main(String[] args) {
        System.out.println(SymmetricTransitiveTupleIndex.selectCanonical(Base.toId((String)"aaa"), Base.toId((String)"bbb")));
    }

    private static XId selectCanonical(XId a, XId b) {
        assert (!a.equals((Object)b));
        if (a.compareTo((Object)b) < 0) {
            return a;
        }
        return b;
    }

    public void deIndex_s_sameAs_o(XId a, XId b) {
        assert (a != null);
        assert (b != null);
        if (a.equals((Object)b)) {
            return;
        }
        XId canonicalOfA = (XId)this.family2canonical.lookup((Object)a);
        XId canonicalOfB = (XId)this.family2canonical.lookup((Object)b);
        if (canonicalOfA == null || canonicalOfB == null) {
            log.warn("canonical(" + a + ")=" + canonicalOfA + " canonical(" + b + ")=" + canonicalOfB);
            return;
        }
        if (canonicalOfA != canonicalOfB) {
            log.trace("different canonicals:canonical(" + a + ")=" + canonicalOfA + " canonical(" + b + ")=" + canonicalOfB);
            return;
        }
        XId canonical = canonicalOfA;
        assert (canonical == canonicalOfB);
    }

    private void deIndexCanonical(XId canonical, XId familyMember) {
        this.canonical2family.deIndex((Object)canonical, (Object)familyMember);
        this.family2canonical.deIndex((Object)familyMember);
    }

    public XId getCanononical(XId id) {
        return (XId)this.family2canonical.lookup((Object)id);
    }

    public void index_s_sameAs_o(XId a, XId b) {
        assert (a != null);
        assert (b != null);
        if (a.equals((Object)b)) {
            return;
        }
        XId canonicalOfA = (XId)this.family2canonical.lookup((Object)a);
        XId canonicalOfB = (XId)this.family2canonical.lookup((Object)b);
        if (canonicalOfA == null) {
            if (canonicalOfB == null) {
                XId winner = SymmetricTransitiveTupleIndex.selectCanonical(a, b);
                if (winner == a) {
                    this.indexCanonical(a, b);
                } else {
                    this.indexCanonical(b, a);
                }
            } else {
                this.indexCanonical(canonicalOfB, a);
            }
        } else if (canonicalOfB == null) {
            this.indexCanonical(canonicalOfA, b);
        } else if (!canonicalOfA.equals((Object)canonicalOfB)) {
            XId winner = SymmetricTransitiveTupleIndex.selectCanonical(canonicalOfA, canonicalOfB);
            if (winner == canonicalOfA) {
                this.migrate(canonicalOfB, canonicalOfA);
            } else {
                assert (winner == canonicalOfB);
                this.migrate(canonicalOfB, canonicalOfA);
            }
        }
    }

    private void indexCanonical(XId canonical, XId familyMember) {
        this.canonical2family.index((Object)canonical, (Object)familyMember);
        this.family2canonical.index((Object)familyMember, (Object)canonical);
    }

    private void migrate(XId canonicalA, XId canonicalB) {
        IEntrySet familyB = this.canonical2family.lookup((Object)canonicalB);
        Set membersB = Iterators.toSet((Iterator)familyB.iterator());
        for (XId b : membersB) {
            this.family2canonical.deIndex((Object)b);
            this.family2canonical.index((Object)canonicalA, (Object)b);
        }
        this.canonical2family.deIndex((Object)canonicalB);
    }
}

