/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.itemtxt;

import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.datafiles.datamap.IDataMap;
import de.xam.datafiles.datamap.MemoryDataMap;
import de.xam.datafiles.handler.IDataFileHandler;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.util.DataFiles;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.ksource.impl.itemtxt.ItemFileHandler;
import de.xam.mybase.model.io.VocabularyMyBase_v100;
import de.xam.mybase.model.names.IdManager;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.id.XidCodec;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DataFileFormat {
    private static final String FILE_PROPERTY_PREFIX = "property_";
    private static final String FILE_RELATION_PREFIX = "relation_";
    private static final String ID = "id";
    private static final String KEY_CONTENT_v1 = DataFileFormat.toPropertyKey(VocabularyMyBase_v100.PROPERTY_CONTENT);
    private static final String KEY_CONTENT_VALUE_v2 = DataFileFormat.toPropertyKey(VocabularyCModel.ATTRIBUTE_CONTENT_VALUE);
    private static final String KEY_CONTENT_TYPE_v2 = DataFileFormat.toPropertyKey(VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI);
    private static final Logger log = LoggerFactory.getLogger(DataFileFormat.class);

    static void copyDataMapToItemAndCreatePropAndRelItems(IWriteMyBase writeMyBase, ICreatePropertyAndRelations createPropertyAndRelations, IItem item, IDataMap dm, IChangeData changeData) {
        block13: for (String key : dm.getKeys()) {
            if (key.equals(ID)) continue;
            IDataMap.Type dataMapValueType = dm.getType(key);
            if (DataFileFormat.isPropertyKey(key)) {
                XId propId = DataFileFormat.extractPropertyId(key);
                createPropertyAndRelations.getOrCreatePropertyWithId(propId, changeData);
                switch (dataMapValueType) {
                    case Boolean: {
                        item.setAttribute(propId, (XValue)XV.toValue((boolean)dm.getBoolean(key)));
                        break;
                    }
                    case Long: {
                        item.setAttribute(propId, (XValue)XV.toValue((long)dm.getLong(key)));
                        break;
                    }
                    case String: {
                        String stringValue = dm.getString(key);
                        item.setAttribute(propId, (XValue)XV.toValue((String)stringValue));
                        break;
                    }
                    case StringSet: {
                        Set strSet = dm.getStringSet(key);
                        for (String str : strSet) {
                            try {
                                XId o = IdManager.toFastRawId((String)str);
                                ItemSets.addRelated((IItemSet)item.itemSet(), (XId)item.getId(), (XId)propId, (XId)o, (IChangeData)changeData);
                            }
                            catch (IllegalArgumentException e) {
                                log.error("Could not create id from '" + str + "' " + DataFileFormat.helpfulText(item, dm, key));
                                throw e;
                            }
                        }
                        continue block13;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled type '" + dataMapValueType + "' as property. " + DataFileFormat.helpfulText(item, dm, key)));
                    }
                }
                continue;
            }
            if (!DataFileFormat.isRelationKey(key)) continue;
            XId relId = DataFileFormat.extractRelationId(key);
            createPropertyAndRelations.getOrCreateRelationWithId(relId, changeData);
            switch (dataMapValueType) {
                case StringSet: {
                    Set strSet = dm.getStringSet(key);
                    for (String targetIdStr : strSet) {
                        if (targetIdStr.length() == 0) {
                            log.warn("Found an empty id (" + item.getId() + "," + key + ",EMPTY)");
                            continue;
                        }
                        try {
                            XId targetId = IdManager.toFastRawId((String)targetIdStr);
                            IItem targetItem = writeMyBase.getItemById(targetId);
                            if (targetItem == null) {
                                String idDecoded = XidCodec.decode((String)targetIdStr);
                                writeMyBase.getOrCreateItemWithId(targetId, idDecoded, changeData);
                            }
                            ItemSets.addRelated((IItemSet)item.itemSet(), (XId)item.getId(), (XId)relId, (XId)targetId, (IChangeData)changeData);
                        }
                        catch (IllegalArgumentException e) {
                            log.error("Could not create id from '" + targetIdStr + "' " + DataFileFormat.helpfulText(item, dm, key));
                            throw e;
                        }
                    }
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Cannot interpret type " + dataMapValueType + " as a relation. " + DataFileFormat.helpfulText(item, dm, key));
                }
            }
        }
    }

    public static XId extractPropertyId(String key) {
        assert (DataFileFormat.isPropertyKey(key)) : "key='" + key + "' could not extract property";
        String propIdString = key.substring(FILE_PROPERTY_PREFIX.length());
        XId propId = IdManager.toFastRawId((String)propIdString);
        return propId;
    }

    private static XId extractRelationId(String key) {
        assert (DataFileFormat.isRelationKey(key));
        String relIdString = key.substring(FILE_RELATION_PREFIX.length());
        XId relId = IdManager.toFastRawId((String)relIdString);
        return relId;
    }

    private static String helpfulText(IItem item, IDataMap dm, String key) {
        return "Was parsing datamap of item='" + item.getId() + "'. " + " Problem with key='" + key + "'. " + "DataMap = " + dm;
    }

    private static boolean isPropertyKey(String key) {
        return key.startsWith(FILE_PROPERTY_PREFIX);
    }

    private static boolean isRelationKey(String key) {
        return key.startsWith(FILE_RELATION_PREFIX);
    }

    static IItem readDataFromItemFileToMyBase(File f, XId id, ICreatePropertyAndRelations createPropertyAndRelations, IWriteMyBase writeMyBase, IChangeData changeData) throws IOException {
        IItem item;
        IDataMap dm = DataFiles.readFileIntoDataMap((File)f, (IDataFileHandler[])new IDataFileHandler[]{new ItemFileHandler()});
        try {
            String content = DataFileFormat.getContentString(dm);
            item = writeMyBase.getOrCreateItemWithId(id, content, changeData);
            DataFileFormat.copyDataMapToItemAndCreatePropAndRelItems(writeMyBase, createPropertyAndRelations, item, dm, changeData);
        }
        catch (Exception e) {
            log.warn("Problem in " + f.getAbsolutePath() + " with dataMap=" + dm.toString(), (Throwable)e);
            throw e;
        }
        return item;
    }

    private static String getContentString(IDataMap dm) {
        String content = dm.getString(KEY_CONTENT_v1);
        if (content == null) {
            content = dm.getString(KEY_CONTENT_VALUE_v2);
            String contentType = dm.getString(KEY_CONTENT_TYPE_v2);
            assert (content == null || contentType.equals("http://purl.org/NET/mediatypes/text/plain") || contentType.equals("http://purl.org/net/xydra/datatypes#string")) : "Unknown content-type '" + contentType + "'";
        }
        return content;
    }

    static String toPropertyKey(XId id) {
        return FILE_PROPERTY_PREFIX + id;
    }

    private static String toRelationKey(XId id) {
        return FILE_RELATION_PREFIX + id;
    }

    public static void write(IWriteMyBase writeMyBase, XId itemId, Set<XId> handledExternally, File targetFile) throws IOException, UnsupportedOperationException {
        long ageItem;
        IItem item = writeMyBase.getItemById(itemId);
        assert (item != null);
        MemoryDataMap dataMap = new MemoryDataMap();
        dataMap.setString(ID, item.getId().toString());
        Iterator propIt = item.attributes();
        while (propIt.hasNext()) {
            XId p = (XId)propIt.next();
            XValue value = item.getAttribute(p);
            if (handledExternally.contains(p)) continue;
            Object javaValue = XV.toJava((XValue)value);
            String propertyKey = DataFileFormat.toPropertyKey(p);
            try {
                dataMap.setValue(propertyKey, javaValue);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not parse " + item.getId() + "." + p + " = '" + javaValue + "'", e);
            }
        }
        Iterator relIt = item.relations();
        while (relIt.hasNext()) {
            XId p = (XId)relIt.next();
            Iterator oIt = item.getRelatedBy(p);
            Set set = Iterators.toSet((Iterator)Iterators.transform((Iterator)oIt, (ITransformer)new ITransformer<XId, String>(){

                public String transform(XId id) {
                    return id.toString();
                }
            }));
            String relKey = DataFileFormat.toRelationKey(p);
            dataMap.setValue(relKey, (Object)set);
        }
        ItemFileHandler ifh = new ItemFileHandler();
        IDataMapStore dms = dataMap.getStore();
        long ageFile = targetFile.lastModified();
        if (ageFile > (ageItem = ChangeDatas.getLastCreationOrModifiedDate((IChangeData)item.getChangeData()))) {
            log.warn("File '" + targetFile + "' was modified " + (ageFile - ageItem) + " ms after item was loaded from it");
        }
        ifh.write(dms, targetFile);
    }

    public static boolean isItemFile(File f) {
        return f.getName().endsWith("item.txt");
    }

    public static interface IWriteMyBase {
        public IItem getItemById(XId var1);

        public IItem getOrCreateItemWithId(XId var1, String var2, IChangeData var3);
    }

    public static interface ICreatePropertyAndRelations {
        public void getOrCreatePropertyWithId(XId var1, IChangeData var2);

        public void getOrCreateRelationWithId(XId var1, IChangeData var2);
    }
}

