/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.commands;

import com.calpano.common.client.commands.DoneCallback;
import com.google.gwt.core.client.Scheduler;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;

public class SynchronizedScheduler {
    private static long activeId = 0L;
    private static long idGen = 1L;
    private static SynchronizedScheduler INSTANCE = new SynchronizedScheduler();
    private static final Logger log = LoggerFactory.getLogger(SynchronizedScheduler.class);

    public static SynchronizedScheduler get() {
        return INSTANCE;
    }

    public static boolean isIdle() {
        return activeId == 0L;
    }

    private static void leaveCriticalSection() {
        activeId = 0L;
    }

    public void scheduleSynchronized(Scheduler.ScheduledCommand synchronizedCmd, DoneCallback doneCallback) {
        SyncronizedScheduledCommand wrapper = new SyncronizedScheduledCommand(synchronizedCmd, doneCallback);
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)wrapper);
    }

    public void scheduleSynchronized(Scheduler.RepeatingCommand repeatingCommand, DoneCallback doneCallback) {
        SynchronizedRepeatingCommand wrapper = new SynchronizedRepeatingCommand(repeatingCommand, doneCallback);
        Scheduler.get().scheduleIncremental((Scheduler.RepeatingCommand)wrapper);
    }

    static /* synthetic */ long access$008() {
        return idGen++;
    }

    private static class SyncronizedScheduledCommand
    extends AbstractSynchronizedCommand
    implements Scheduler.ScheduledCommand {
        private final Scheduler.ScheduledCommand command;
        private final DoneCallback doneCallback;

        public SyncronizedScheduledCommand(Scheduler.ScheduledCommand scheduledCommand, DoneCallback doneCallback) {
            this.command = scheduledCommand;
            this.doneCallback = doneCallback;
        }

        public void execute() {
            if (this.canRun()) {
                this.enterCriticalSection();
                this.command.execute();
                SynchronizedScheduler.leaveCriticalSection();
                if (this.doneCallback != null) {
                    this.doneCallback.done();
                }
            } else {
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)this);
            }
        }
    }

    private static class SynchronizedRepeatingCommand
    extends AbstractSynchronizedCommand
    implements Scheduler.RepeatingCommand {
        private final DoneCallback doneCallback;
        private final Scheduler.RepeatingCommand repeatingCommand;

        public SynchronizedRepeatingCommand(Scheduler.RepeatingCommand repeatingCommand, DoneCallback doneCallback) {
            this.doneCallback = doneCallback;
            this.repeatingCommand = repeatingCommand;
        }

        public boolean execute() {
            if (this.canRun()) {
                this.enterCriticalSection();
                boolean repeat = this.repeatingCommand.execute();
                if (!repeat) {
                    SynchronizedScheduler.leaveCriticalSection();
                    if (this.doneCallback != null) {
                        this.doneCallback.done();
                    }
                }
                return repeat;
            }
            Scheduler.get().scheduleIncremental((Scheduler.RepeatingCommand)this);
            return false;
        }
    }

    public static class AggregateDoneCallback
    implements DoneCallback {
        private int calls = 0;
        private final DoneCallback combinedCallback;
        private final String debugName;
        private int expectedCalls;

        public AggregateDoneCallback(String debugName, int expectedCalls, DoneCallback combinedCallback) {
            this.debugName = debugName;
            this.expectedCalls = expectedCalls;
            this.combinedCallback = combinedCallback;
        }

        @Override
        public void done() {
            ++this.calls;
            log.debug((this.calls == this.expectedCalls ? "Completed" : "Did") + " " + this.calls + "/" + this.expectedCalls + " of '" + this.debugName + "'");
            XyAssert.xyAssert((this.calls <= this.expectedCalls ? 1 : 0) != 0, (String)"Received more calls than expected: %s instead of %s", (Object[])new Object[]{this.calls, this.expectedCalls});
            if (this.calls == this.expectedCalls) {
                this.combinedCallback.done();
            }
        }

        public void expectOneMore() {
            ++this.expectedCalls;
        }
    }

    private static abstract class AbstractSynchronizedCommand {
        protected final long id = SynchronizedScheduler.access$008();

        public boolean canRun() {
            return SynchronizedScheduler.isIdle() || this.myIdIsActive();
        }

        protected void enterCriticalSection() {
            activeId = this.id;
        }

        public boolean myIdIsActive() {
            return activeId == this.id;
        }
    }
}

