/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.util;

import com.google.gwt.user.client.Window;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class PushState {
    private static final Logger log = LoggerFactory.getLogger(PushState.class);
    private static final boolean SUPPORT = PushState.isSupported();

    public static native boolean isSupported();

    public void pushState(String data, String title, String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.pushState(data, title, url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public void pushStateNoData(String title, String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.pushStateNoData(title, url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public void pushStateNoData(String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.pushStateNoData(url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public void replaceStateNoData(String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.replaceStateNoData(url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public void replaceState(String data, String title, String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.replaceState(data, title, url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public void replaceStateNoData(String title, String url, boolean reloadPageIfPushStateUnsupported) {
        if (SUPPORT) {
            this.replaceStateNoData(title, url);
        } else if (reloadPageIfPushStateUnsupported) {
            PushState.setUrl(url);
        }
    }

    public native void pushState(String var1, String var2, String var3);

    public native void pushStateNoData(String var1, String var2);

    public native void pushStateNoData(String var1);

    public native void replaceStateNoData(String var1);

    public native void replaceState(String var1, String var2, String var3);

    public native void replaceStateNoData(String var1, String var2);

    private static void setUrl(String url) {
        String currentLocation = Window.Location.getHref();
        if (!currentLocation.equals(url)) {
            Window.Location.assign((String)url);
        } else {
            log.info("We are already on '" + currentLocation + "' so no need to reload.");
        }
    }

    static {
        log.info("On this browser HTML5 history.replaceState is " + (SUPPORT ? "well" : "not") + " supported");
    }
}

