/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class IconWithLabelDisclosurePanel
extends Composite
implements HasOpenHandlers<IconWithLabelDisclosurePanel>,
HasCloseHandlers<IconWithLabelDisclosurePanel> {
    private static final Logger log = LoggerFactory.getLogger(IconWithLabelDisclosurePanel.class);
    private Image image;
    private Widget label;
    private Widget content;
    private boolean isShowing;
    private final FlowPanel panel;
    private final FocusPanel togglePanel = new FocusPanel();

    public IconWithLabelDisclosurePanel() {
        this.panel = new FlowPanel();
        this.panel.getElement().getStyle().setDisplay(Style.Display.INLINE);
        this.togglePanel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                IconWithLabelDisclosurePanel.this.toggle();
            }
        });
        this.togglePanel.add((Widget)this.panel);
        this.initWidget((Widget)this.togglePanel);
    }

    private void toggle() {
        if (this.isShowing) {
            this.hideContent();
        } else {
            this.showContent();
        }
    }

    public void open() {
        if (this.isShowing) {
            return;
        }
        this.showContent();
    }

    public void close() {
        if (!this.isShowing) {
            return;
        }
        this.hideContent();
    }

    private void showContent() {
        this.isShowing = true;
        this.content.setVisible(true);
        OpenEvent.fire((HasOpenHandlers)this, (Object)((Object)this));
    }

    private void hideContent() {
        this.isShowing = false;
        this.content.setVisible(false);
        CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)this));
    }

    public void setContent(Widget content) {
        this.content = content;
    }

    public HandlerRegistration addCloseHandler(CloseHandler<IconWithLabelDisclosurePanel> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    public HandlerRegistration addOpenHandler(OpenHandler<IconWithLabelDisclosurePanel> handler) {
        return this.addHandler((EventHandler)handler, OpenEvent.getType());
    }

    @UiChild(limit=1, tagname="icon")
    public void addIcon(Widget w) {
        assert (w instanceof Image);
        this.image = (Image)w;
        this.panel.add((Widget)this.image);
    }

    @UiChild(limit=1, tagname="label")
    public void addLabel(Widget w) {
        assert (w instanceof Label);
        this.label = w;
        this.panel.add(this.label);
    }
}

