/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms;

import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.xydra.annotations.LicenseApache;

@LicenseApache(project="gwt-eye-candy")
public class Tooltip {
    private final PopupPanel popupPanel = new PopupPanel();
    private final SimplePanel panel = new SimplePanel();
    private final SimplePanel wrapper = new SimplePanel();
    private Widget widget;
    private boolean showing;
    private TooltipPosition position = TooltipPosition.BELOW_LEFT;
    private Box widgetBox = new Box(0, 0, 0, 0);
    protected int popupOffsetWidth;
    protected int popupOffsetHeight;
    final PopupPanel.PositionCallback POSITION_CALLBACK = new PopupPanel.PositionCallback(){

        public void setPosition(int offsetWidth, int offsetHeight) {
            Tooltip.this.popupOffsetWidth = offsetWidth;
            Tooltip.this.popupOffsetHeight = offsetHeight;
            Tooltip.this.widgetBox = new Box(Tooltip.this.widget.getAbsoluteLeft(), Tooltip.this.widget.getAbsoluteTop(), Tooltip.this.widget.getOffsetWidth(), Tooltip.this.widget.getOffsetHeight());
            Pos pos = Tooltip.this.calcPopupPos(Tooltip.this.widgetBox);
            Tooltip.this.popupPanel.setPopupPosition(pos.x, pos.y);
        }
    };

    public void hideTooltip() {
        this.showing = false;
        this.popupPanel.hide();
    }

    private static boolean isMouseOutOfWidget(MouseEvent<?> event, Widget widget) {
        int x = event.getClientX();
        int y = event.getClientY();
        return x <= widget.getAbsoluteLeft() || x >= widget.getAbsoluteLeft() + widget.getOffsetWidth() || y <= widget.getAbsoluteTop() || y >= widget.getAbsoluteTop() + widget.getOffsetHeight();
    }

    public Tooltip() {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        this.panel.setStyleName(CommonResourceBundle.INSTANCE.css().tooltip());
        this.wrapper.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.wrapper.add((Widget)this.panel);
        this.popupPanel.add((Widget)this.wrapper);
    }

    public Tooltip(IsWidget content) {
        this();
        this.panel.setWidget(content);
    }

    public Tooltip setContent(IsWidget content) {
        this.panel.setWidget(content);
        return this;
    }

    public Tooltip setText(String text) {
        this.panel.setWidget((Widget)new Label(text));
        return this;
    }

    public Tooltip setHtml(SafeHtml html) {
        this.panel.setWidget((Widget)new HTML(html));
        return this;
    }

    public Tooltip setPosition(TooltipPosition position) {
        this.position = position;
        return this;
    }

    public Tooltip attachTo(Widget widget) {
        this.widget = widget;
        return this;
    }

    public Tooltip setStyleName(String style) {
        this.panel.setStyleName(style);
        return this;
    }

    public Tooltip addStyleName(String style) {
        this.panel.addStyleName(style);
        return this;
    }

    public void showTooltipDelayed(int delay) {
        this.showing = true;
        Scheduler.get().scheduleFixedDelay(new Scheduler.RepeatingCommand(){
            private boolean ran = false;

            public boolean execute() {
                if (!this.ran) {
                    this.ran = true;
                    return true;
                }
                Tooltip.this.showTooltipTechnically();
                return false;
            }
        }, delay);
    }

    public void showTooltip() {
        this.showing = true;
        this.showTooltipTechnically();
    }

    private void showTooltipTechnically() {
        if (!this.showing) {
            return;
        }
        this.popupPanel.setPopupPositionAndShow(this.POSITION_CALLBACK);
        Scheduler.get().scheduleFixedDelay(new Scheduler.RepeatingCommand(){

            public boolean execute() {
                Tooltip.this.moveTooltipIfNecessary();
                return Tooltip.this.panel.isVisible();
            }
        }, 200);
    }

    protected Pos calcPopupPos(Box widgetBox) {
        int x = 0;
        int y = 0;
        switch (this.position) {
            case ABOVE_CENTER: {
                x = widgetBox.x + (widgetBox.width - this.popupOffsetWidth) / 2;
                y = widgetBox.y - this.popupOffsetHeight + 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case ABOVE_LEFT: {
                x = widgetBox.x;
                y = widgetBox.y - this.popupOffsetHeight + 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case ABOVE_RIGHT: {
                x = widgetBox.x + widgetBox.width - this.popupOffsetWidth;
                y = widgetBox.y - this.popupOffsetHeight + 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case BELOW_CENTER: {
                x = widgetBox.x + (widgetBox.width - this.popupOffsetWidth) / 2;
                y = widgetBox.y + widgetBox.height - 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case BELOW_LEFT: {
                x = widgetBox.x;
                y = widgetBox.y + widgetBox.height - 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case BELOW_RIGHT: {
                x = widgetBox.x + widgetBox.width - this.popupOffsetWidth;
                y = widgetBox.y + widgetBox.height - 1;
                this.panel.setWidth(0.9 * (double)widgetBox.width + "px");
                break;
            }
            case LEFT_TOP: {
                x = widgetBox.x - this.popupOffsetWidth + 1;
                y = widgetBox.y;
                break;
            }
            case LEFT_MIDDLE: {
                x = widgetBox.x - this.popupOffsetWidth + 1;
                y = widgetBox.y + (widgetBox.height - this.popupOffsetHeight) / 2;
                break;
            }
            case LEFT_BOTTOM: {
                x = widgetBox.x - this.popupOffsetWidth + 1;
                y = widgetBox.y + widgetBox.height - this.popupOffsetHeight;
                break;
            }
            case RIGHT_TOP: {
                x = widgetBox.x + widgetBox.width - 1;
                y = widgetBox.y;
                break;
            }
            case RIGHT_MIDDLE: {
                x = widgetBox.x + widgetBox.width - 1;
                y = widgetBox.y + (widgetBox.height - this.popupOffsetHeight) / 2;
                break;
            }
            case RIGHT_BOTTOM: {
                x = widgetBox.x + widgetBox.width - 1;
                y = widgetBox.y + widgetBox.height - this.popupOffsetHeight;
            }
        }
        return new Pos(x, y);
    }

    protected void moveTooltipIfNecessary() {
        Box currentBox = new Box(this.widget.getAbsoluteLeft(), this.widget.getAbsoluteTop(), this.widget.getOffsetWidth(), this.widget.getOffsetHeight());
        if (!currentBox.isEqual(this.widgetBox)) {
            this.widgetBox = currentBox;
            Pos pos = this.calcPopupPos(this.widgetBox);
            this.popupPanel.setPopupPosition(pos.x, pos.y);
        }
    }

    public void showHTML(SafeHtml html) {
        if (this.panel.getWidget() instanceof HTML) {
            ((HTML)this.panel.getWidget()).setHTML(html);
        } else {
            this.panel.setWidget((Widget)new HTML(html));
        }
        this.showTooltip();
    }

    public void showWidget(IsWidget widget) {
        this.panel.setWidget(widget);
        this.showTooltip();
    }

    static class Pos {
        int x;
        int y;

        public Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    static class Box {
        public int x;
        public int y;
        public int width;
        public int height;

        public Box(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean isEqual(Box other) {
            return this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height;
        }
    }

    public static enum TooltipPosition {
        BELOW_LEFT,
        BELOW_CENTER,
        BELOW_RIGHT,
        ABOVE_LEFT,
        ABOVE_CENTER,
        ABOVE_RIGHT,
        LEFT_TOP,
        LEFT_MIDDLE,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_MIDDLE,
        RIGHT_BOTTOM;

    }
}

