/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.validation.impl;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.view.forms.Html5DomUtil;
import com.calpano.common.client.view.forms.IHtml5TextInput;
import com.calpano.common.client.view.forms.validation.HasInvaliationHandlers;
import com.calpano.common.client.view.forms.validation.HasValidationHandlers;
import com.calpano.common.client.view.forms.validation.InvalidationEvent;
import com.calpano.common.client.view.forms.validation.InvalidationHandler;
import com.calpano.common.client.view.forms.validation.ValidationEvent;
import com.calpano.common.client.view.forms.validation.ValidationHandler;
import com.calpano.common.shared.validation.IStringValidator;
import com.calpano.common.shared.validation.TextValidator;
import com.calpano.common.shared.validation.ValidationMessage;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CalculateValidationHelper
implements HasValidationHandlers,
HasInvaliationHandlers {
    private static final Logger log = LoggerFactory.getLogger(CalculateValidationHelper.class);
    private ValidationMessage currentValidationMessage;
    private ValidationMessage lastFiredValidationMessage = null;
    private boolean required = false;
    private final boolean simulateValidation;
    private final IHtml5TextInput source;
    private String type = "";
    private boolean validation = false;
    private final SortedMap<Integer, IStringValidator> validators = new TreeMap<Integer, IStringValidator>();

    public void setValidation(boolean active) {
        this.validation = active;
    }

    public CalculateValidationHelper(IHtml5TextInput source, boolean simulateValidation) {
        this.source = source;
        this.simulateValidation = simulateValidation;
        this.source.getTextBoxBase().addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                CalculateValidationHelper.this.onUserTypedTextChanged((String)event.getValue());
            }
        });
    }

    public void addValidator(Integer order, IStringValidator validator) {
        this.validators.put(order, validator);
    }

    void computeAndFireEvents(String userTypedText) {
        this.computeValidation();
        if (!this.currentValidationMessage.equals(this.lastFiredValidationMessage)) {
            log.trace("firing now " + this.currentValidationMessage);
            this.fireValidityChangeEvent(this.currentValidationMessage);
        } else {
            log.trace("fired already " + this.lastFiredValidationMessage);
        }
    }

    private void fireValidityChangeEvent(ValidationMessage m) {
        if (m.level.isValid()) {
            ClientApp.getEventBus().fireEventFromSource((Event)new ValidationEvent(this.source), (Object)this.source);
        } else {
            ClientApp.getEventBus().fireEventFromSource((Event)new InvalidationEvent(this.source), (Object)this.source);
        }
        this.lastFiredValidationMessage = m;
    }

    public String getType() {
        return this.type;
    }

    public ValidationMessage getValidationMessage() {
        return this.currentValidationMessage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void onLoad() {
        this.addValidator(2, (IStringValidator)new TextValidator(this.isRequired(), this.getType(), "Global__errorNoEmailAddress__pageMessage", "Global__errorInvalidEmail__pageMessage"));
        String userTypedText = this.source.getText();
        this.computeAndFireEvents(userTypedText);
    }

    private void onUserTypedTextChanged(String userTypedText) {
        if (!this.validation) {
            return;
        }
        this.computeAndFireEvents(userTypedText);
    }

    public void reset() {
        this.lastFiredValidationMessage = null;
    }

    public void setRequired(boolean required) {
        this.required = required;
        if (!this.simulateValidation) {
            Html5DomUtil.setPropertyString((Widget)this.source.getTextBoxBase(), "required", "required");
        }
    }

    public void setRequired(String attributeValue) {
        if (attributeValue.equals("required") || attributeValue.equals("")) {
            this.setRequired(true);
        }
    }

    public void setType(String type) {
        String string = this.type = type != null ? type : "";
        if (!this.simulateValidation) {
            Html5DomUtil.setPropertyString((Widget)this.source.getTextBoxBase(), "type", type);
        }
    }

    @Override
    public HandlerRegistration addInvalidationHandler(InvalidationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(InvalidationEvent.TYPE, (Object)this.source, (Object)handler);
    }

    @Override
    public HandlerRegistration addValidationHandler(ValidationHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(ValidationEvent.TYPE, (Object)this.source, (Object)handler);
    }

    public ValidationMessage computeValidation() {
        String userTypedText = this.source.getText();
        ValidationMessage worst = ValidationMessage.ALL_OK;
        for (IStringValidator v : this.validators.values()) {
            ValidationMessage m = v.computeValidation(userTypedText);
            log.trace("Validator " + v.getClass() + " says: " + m);
            if (m.level.moreCriticalThan(worst.level)) {
                worst = m;
            }
            if (worst.level != ValidationMessage.Level.ErrorWrong) continue;
            break;
        }
        this.currentValidationMessage = worst;
        log.trace("validating content '" + userTypedText + "' as " + this.currentValidationMessage);
        return this.currentValidationMessage;
    }

    public void onUnload() {
        this.validators.clear();
    }
}

