/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PropertyContainer;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicEvent;
import com.sonicmetrics.core.shared.query.SonicFilter;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import com.sonicmetrics.gaeserver.impl.SonicEventCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xydra.store.impl.gae.UniCache;
import org.xydra.xgae.XGae;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;

@Deprecated
public class CachedEvents
implements UniCache.CacheEntryHandler<CachedEvents>,
Serializable {
    private static final long serialVersionUID = 1L;
    private GaeSonicDB.TimeInterval timeInterval = null;
    private SonicFilter filter = null;
    private final List<SonicEvent> events = new ArrayList<SonicEvent>();
    private Granularity granularity;
    private transient long size = 0L;
    private static final long RESERVED_BYTES = 1024L;
    private static final long MAX_SIZE = 0x100000L;

    public CachedEvents(SonicFilter filter, Granularity granularity) {
        this.filter = filter;
        this.granularity = granularity;
    }

    CachedEvents() {
    }

    public void addEvent(SonicEvent se) {
        long seSize = se.size();
        if (this.size + seSize + 1024L >= 0x100000L) {
            throw new FullException("Stored already an estimate of " + this.size + " bytes. Cannot add another " + seSize + " bytes without coming too close to the limit of " + 0x100000L);
        }
        this.size += seSize;
        this.events.add(se);
        if (this.timeInterval == null) {
            this.timeInterval = new GaeSonicDB.TimeInterval(se.getWhen(), se.getWhen());
        } else {
            this.timeInterval.includeTime(se.getWhen());
        }
    }

    public long size() {
        return this.size();
    }

    public SEntity toEntity(SKey datastoreKey, CachedEvents ce) {
        SEntity e = XGae.get().datastore().createEntity(datastoreKey);
        for (SonicEvent se : this.events) {
            EmbeddedEntity ee = new EmbeddedEntity();
            SonicEventCodec.addGaeProperties((PropertyContainer)ee, (ISonicEvent)se);
            Key key = SonicEventCodec.generateKey((ISonicEvent)se);
            ee.setKey(key);
            e.setAttribute(key.toString(), (Serializable)ee);
        }
        return e;
    }

    public CachedEvents fromEntity(SEntity entity) {
        CachedEvents ce = new CachedEvents();
        for (Object e : entity.getAttributes().values()) {
            EmbeddedEntity ee = (EmbeddedEntity)e;
            long when = SonicEventCodec.getWhenFromKey(ee.getKey());
            SonicEvent.SeBuilder b = SonicEventCodec.fromPropertyContainer(when, (PropertyContainer)ee);
            SonicEvent se = (SonicEvent)b.build();
            se.setKey(ee.getKey().toString());
            System.out.println("from entity " + se);
            ce.events.add(se);
        }
        Collections.sort(ce.events);
        return ce;
    }

    public Serializable toSerializable(CachedEvents entry) {
        return entry;
    }

    public CachedEvents fromSerializable(Serializable s) {
        return (CachedEvents)s;
    }

    public static Object fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bin);
        return ois.readObject();
    }

    public static byte[] toBytes(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        return bos.toByteArray();
    }

    public GaeSonicDB.TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public boolean canContainTimepoint(long utc) {
        return new GaeSonicDB.TimeInterval(this.timeInterval.getStart(), this.timeInterval.getStart() + this.granularity.getLengthInMillis()).contains(utc);
    }

    public static enum Granularity {
        Day(86400000L),
        Segment(2400000L),
        Minute(60000L),
        Second(1000L),
        Continuous(-1L);

        private long millis;

        public long getLengthInMillis() {
            return this.millis;
        }

        private Granularity(long millis) {
            this.millis = millis;
        }
    }

    public static final class FullException
    extends RuntimeException {
        private static final long serialVersionUID = 2033791708837931985L;

        public FullException(String msg) {
            super(msg);
        }
    }
}

