/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.rest;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Query;
import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.ISonicPotentialEvent;
import com.sonicmetrics.core.shared.query.BuiltinKeyValueConstraint;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.KeyValueConstraint;
import com.sonicmetrics.core.shared.query.SonicQuery;
import com.sonicmetrics.core.shared.query.TimeConstraint;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import com.sonicmetrics.gaeserver.impl.GaeUtils;
import com.sonicmetrics.gaeserver.impl.SonicEventCodec;
import com.sonicmetrics.gaeserver.rest.SonicResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.xgae.gaeutils.GaeTestfixer;

public class QueryResource
extends SonicResource {
    private static final Logger log = LoggerFactory.getLogger(QueryResource.class);

    public static void restless(Restless restless, boolean allowAll) {
        RestlessParameter[] queryParams = new RestlessParameter[]{new RestlessParameter("lastkey", null), new RestlessParameter("start", null), new RestlessParameter("end", null), new RestlessParameter("category", null), new RestlessParameter("action", null), new RestlessParameter("label", null), new RestlessParameter("subject", null), new RestlessParameter("source", null), new RestlessParameter("callback", null)};
        restless.addMethod("/events", "GET", QueryResource.class, "events", !allowAll, queryParams);
        restless.addMethod("/events", "POST", QueryResource.class, "events", !allowAll, queryParams);
        restless.addMethod("/v2/events", "GET", QueryResource.class, "events", !allowAll, queryParams);
        restless.addMethod("/v2/events", "POST", QueryResource.class, "events", !allowAll, queryParams);
    }

    public static void events(String lastKey, String startStr, String endStr, String category, String action, String label, String subject, String source, String callback, IRestlessContext ctx) throws IOException {
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        TimeConstraint tc = null;
        if (QueryResource.isDefined(lastKey)) {
            tc = TimeConstraint.sinceLastkey((String)lastKey);
        } else if (QueryResource.isDefined(startStr)) {
            try {
                long start = Long.parseLong(startStr);
                long end = Long.MAX_VALUE;
                if (QueryResource.isDefined(endStr)) {
                    try {
                        end = Long.parseLong(endStr);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (end == Long.MAX_VALUE) {
                    end = GaeSonicDB.INSTANCE.getCurrentTime();
                }
                tc = TimeConstraint.fromTo((long)start, (long)end);
            }
            catch (NumberFormatException e) {
                ctx.getResponse().sendError(400, "Your 'start' could not be parsed as a long.");
            }
        } else {
            ctx.getResponse().sendError(400, "You must define either 'lastkey' or 'start'");
        }
        assert (tc != null);
        SonicQuery.Builder b = SonicQuery.build((TimeConstraint)tc);
        if (QueryResource.isDefined(subject)) {
            b.where((KeyValueConstraint)BuiltinKeyValueConstraint.keyValue((ISonicPotentialEvent.FilterProperty)ISonicPotentialEvent.FilterProperty.Subject, (String)subject));
        }
        if (QueryResource.isDefined(category)) {
            b.where((KeyValueConstraint)BuiltinKeyValueConstraint.keyValue((ISonicPotentialEvent.FilterProperty)ISonicPotentialEvent.FilterProperty.Category, (String)category));
        }
        if (QueryResource.isDefined(action)) {
            b.where((KeyValueConstraint)BuiltinKeyValueConstraint.keyValue((ISonicPotentialEvent.FilterProperty)ISonicPotentialEvent.FilterProperty.Action, (String)action));
        }
        if (QueryResource.isDefined(label)) {
            b.where((KeyValueConstraint)BuiltinKeyValueConstraint.keyValue((ISonicPotentialEvent.FilterProperty)ISonicPotentialEvent.FilterProperty.Label, (String)label));
        }
        if (QueryResource.isDefined(source)) {
            b.where((KeyValueConstraint)BuiltinKeyValueConstraint.keyValue((ISonicPotentialEvent.FilterProperty)ISonicPotentialEvent.FilterProperty.Source, (String)source));
        }
        SonicQuery sonicQuery = b.done();
        log.info("Query for " + sonicQuery);
        try {
            Query query = SonicEventCodec.toGaeQuery((ISonicQuery)sonicQuery);
            Iterator<Entity> it = GaeUtils.toIterator(query, 10000);
            Iterator<ISonicEvent> resultIt = SonicEventCodec.convert(it, 10005L);
            QueryResource.sendEvents(resultIt, ctx.getResponse(), callback);
        }
        catch (Throwable e) {
            log.info("Error while processing query result", e);
            ctx.getResponse().sendError(400, "Query on server caused trouble: " + e.getMessage());
        }
    }

    private static void sendEvents(Iterator<ISonicEvent> it, HttpServletResponse res, String callback) throws IOException {
        ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"application/json");
        PrintWriter w = res.getWriter();
        if (QueryResource.isDefined(callback)) {
            ((Writer)w).write(callback + "(");
        }
        long c = 0L;
        ((Writer)w).write("[");
        while (it.hasNext()) {
            ++c;
            ISonicEvent gse = it.next();
            ((Writer)w).write(gse.toJsonObject().toString());
            if (it.hasNext()) {
                ((Writer)w).write(",\n");
            }
            ((Writer)w).flush();
        }
        ((Writer)w).write("]");
        log.debug("Returned " + c + " events");
        if (QueryResource.isDefined(callback)) {
            ((Writer)w).write(")");
        }
        ((Writer)w).flush();
        ((Writer)w).close();
    }
}

