/*
 * Decompiled with CFR 0.152.
 */
package de.xam.memspace;

import de.xam.memspace.AbstractProfileNode;
import de.xam.memspace.AbstractShellProfileNode;
import de.xam.memspace.ILink;
import de.xam.memspace.IObjectProfileNode;
import java.io.IOException;
import java.util.Arrays;

final class ObjectProfileNode
extends AbstractProfileNode {
    IObjectProfileNode[] children;
    final ILink link;
    final Object object;
    int refcount;
    AbstractShellProfileNode shell;

    ObjectProfileNode(ObjectProfileNode parent, Object obj, ILink link) {
        super(parent);
        this.object = obj;
        this.link = link;
        this.refcount = 1;
        this.children = EMPTY_OBJECTPROFILENODE_ARRAY;
    }

    void addFieldRef(IObjectProfileNode node) {
        IObjectProfileNode[] children = this.children;
        int childrenLength = children.length;
        if (this.size >= childrenLength) {
            IObjectProfileNode[] newchildren = new IObjectProfileNode[Math.max(1, childrenLength << 1)];
            System.arraycopy(children, 0, newchildren, 0, childrenLength);
            children = newchildren;
            this.children = newchildren;
        }
        children[this.size++] = node;
    }

    @Override
    public IObjectProfileNode[] children() {
        return this.children;
    }

    void finish() {
        int childCount = this.size;
        if (childCount > 0) {
            if (childCount < this.children.length) {
                IObjectProfileNode[] newadj = new IObjectProfileNode[childCount];
                System.arraycopy(this.children, 0, newadj, 0, childCount);
                this.children = newadj;
            }
            Arrays.sort(this.children);
            int size = 0;
            for (int i = 0; i < childCount; ++i) {
                size += this.children[i].size();
            }
            this.size = size;
        }
    }

    @Override
    public String name() {
        return this.link == null ? "<INPUT>" : this.link.name();
    }

    @Override
    public Object object() {
        return this.object;
    }

    @Override
    public int refcount() {
        return this.refcount;
    }

    @Override
    public IObjectProfileNode shell() {
        return this.shell;
    }

    @Override
    public boolean traverse(IObjectProfileNode.INodeFilter filter, IObjectProfileNode.INodeVisitor visitor) throws IOException {
        if (visitor != null && (filter == null || filter.accept(this))) {
            visitor.previsit(this);
            IObjectProfileNode[] children = this.children;
            for (int i = 0; i < children.length; ++i) {
                children[i].traverse(filter, visitor);
            }
            visitor.postvisit(this);
            return true;
        }
        return false;
    }
}

