/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared;

import de.xam.p13n.shared.SharedLocaleUtils;
import java.io.Serializable;

public class MiniLocale
implements Serializable {
    private static final long serialVersionUID = -7118237432961172658L;
    public static final MiniLocale CANADA = new MiniLocale("en", "ca");
    public static final MiniLocale De_DE = new MiniLocale("de", "de");
    public static final MiniLocale EN_US = new MiniLocale("en", "us");
    public static final MiniLocale ENGLISH = new MiniLocale("en");
    public static final MiniLocale UK = new MiniLocale("en", "gb");
    private String country;
    private String language;
    private String variant;

    public MiniLocale() {
    }

    public MiniLocale(String language) {
        this.language = language;
    }

    public MiniLocale(String language, String country) {
        this.language = language;
        this.country = country;
    }

    public MiniLocale(String language, String country, String variant) {
        this.language = language;
        this.country = country;
        this.variant = variant;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getVariant() {
        return this.variant;
    }

    public String toString() {
        return SharedLocaleUtils.toString(this, 3);
    }

    public static MiniLocale fromLocaleCode(String localeCode) {
        String[] localParts = localeCode.split("_");
        if (localParts.length == 1) {
            return new MiniLocale(localParts[0]);
        }
        if (localParts.length == 2) {
            return new MiniLocale(localParts[0], localParts[1]);
        }
        if (localParts.length == 3) {
            return new MiniLocale(localParts[0], localParts[1], localParts[2]);
        }
        throw new IllegalArgumentException("Encountered locale-def with wrong format '" + localeCode + "'");
    }
}

