/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared;

import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.SharedLocaleUtils;
import de.xam.p13n.shared.time.MiniTimeZone;
import java.io.Serializable;
import org.xydra.annotations.Setting;
import org.xydra.annotations.Template;

public class Personalisation
implements Serializable {
    private static final long serialVersionUID = 2597415344829634481L;
    public static final Personalisation EN_US__SAN_FRANCISCO = new Personalisation(MiniLocale.EN_US, MiniTimeZone.US_SAN_FRANCISCO);
    public static final Personalisation GERMANY = new Personalisation(MiniLocale.De_DE, MiniTimeZone.GERMANY_BERLIN);
    @Setting(value="Default personalisation for anything: San Francisco, US")
    public static final Personalisation DEFAULT = EN_US__SAN_FRANCISCO;
    public static final String ZZZ = "ZZZ";
    private MiniLocale locale;
    private MiniTimeZone timeZone;

    public Personalisation() {
    }

    public static Personalisation create(String localeString, int utcOffset) {
        MiniLocale locale = SharedLocaleUtils.fromString(localeString);
        return new Personalisation(locale, utcOffset);
    }

    public static Personalisation fromString(String compactString) {
        if (compactString == null) {
            return null;
        }
        int zzz = compactString.indexOf(ZZZ);
        if (zzz > 0) {
            String langString = compactString.substring(0, zzz);
            String offsetString = compactString.substring(zzz + ZZZ.length(), compactString.length());
            MiniLocale locale = SharedLocaleUtils.fromString(langString);
            MiniTimeZone timeZone = MiniTimeZone.fromString(offsetString);
            return new Personalisation(locale, timeZone);
        }
        throw new IllegalArgumentException("'" + compactString + "' must contain '" + ZZZ + "'");
    }

    public Personalisation(MiniLocale locale, int utcOffset) {
        this.locale = locale;
        this.timeZone = new MiniTimeZone(utcOffset);
    }

    public Personalisation(MiniLocale locale, MiniTimeZone timeZone) {
        this.locale = locale;
        this.timeZone = timeZone;
    }

    @Template(value="MiniLocale")
    public MiniLocale getLocale() {
        return this.locale;
    }

    @Template(value="MiniTimezone")
    public MiniTimeZone getTimeZone() {
        return this.timeZone;
    }

    @Template(value="UTC offset")
    public int getUtcOffset() {
        return this.timeZone.getUtcOffset();
    }

    public String toClassifier(int precision) {
        String ext = SharedLocaleUtils.toString(this.locale, precision);
        if (ext.length() == 0) {
            return "";
        }
        return "_" + ext;
    }

    public String toCompactString() {
        String c = this.locale + ZZZ + this.timeZone.toCompactString();
        return c;
    }

    public String toString() {
        return this.toCompactString();
    }

    public boolean equals(Object other) {
        return other instanceof Personalisation && ((Personalisation)other).locale.toString().equals(this.locale.toString()) && ((Personalisation)other).timeZone.toCompactString().equals(this.timeZone.toCompactString());
    }

    public int hashCode() {
        return this.locale.hashCode() + this.timeZone.hashCode();
    }
}

