/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared.time;

import de.xam.p13n.shared.time.MiniLocalDate;
import de.xam.p13n.shared.time.TimeProvider;
import java.util.Date;

public class MiniDateTime
implements Comparable<MiniDateTime> {
    private transient Date date;
    private final long millis;

    public MiniDateTime(int year, int monthOfYear, int dayOfMonth, int hour, int minute, int second, int millis) {
        this.millis = Date.UTC(year - 1900, monthOfYear - 1, dayOfMonth, hour, minute, second);
    }

    public MiniDateTime(long millis) {
        this.millis = millis;
    }

    public boolean equals(Object other) {
        return other instanceof MiniDateTime && ((MiniDateTime)other).millis == this.millis;
    }

    public int getDayOfMonth() {
        this.lazyInitDate();
        return this.date.getDate();
    }

    public long getMillis() {
        return this.millis;
    }

    public int getMonthOfYear() {
        this.lazyInitDate();
        return this.date.getMonth() + 1;
    }

    public int getYear() {
        this.lazyInitDate();
        return this.date.getYear() + 1900;
    }

    public int hashCode() {
        return new Long(this.millis).hashCode();
    }

    private void lazyInitDate() {
        if (this.date == null) {
            this.date = new Date(this.millis);
            int offsetMinutes = this.date.getTimezoneOffset();
            long offsetMillis = offsetMinutes * 60 * 1000;
            this.date.setTime(this.millis + offsetMillis);
        }
    }

    public MiniLocalDate toLocalDate() {
        return new MiniLocalDate(this.getMillis());
    }

    public String toString() {
        this.lazyInitDate();
        return this.toLocalDate().toString() + "-" + this.date.getHours() + "-" + this.date.getMinutes() + "-" + this.date.getSeconds();
    }

    @Override
    public int compareTo(MiniDateTime other) {
        if (other == null) {
            return -1;
        }
        if (this.millis < other.millis) {
            return -1;
        }
        if (other.millis == this.millis) {
            return 0;
        }
        return 1;
    }

    public static MiniDateTime now() {
        return new MiniDateTime(TimeProvider.getCurrentTimeInMillis());
    }

    public static int minutesBetween(MiniDateTime a, MiniDateTime b) {
        if (a == null || b == null || a.millis == -1L || b.millis == -1L || a.millis == 0L || b.millis == 0L) {
            return -1;
        }
        long millis = b.millis - a.millis;
        int minutes = (int)(millis / 60000L);
        return minutes;
    }
}

