/*
 * Decompiled with CFR 0.152.
 */
package de.xam.p13n.shared.time;

import de.xam.p13n.shared.time.MiniDateTime;
import java.util.Date;
import org.xydra.annotations.Template;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TimeProvider {
    protected static long fakeTime_ = 0L;
    private static final Logger log = LoggerFactory.getLogger(TimeProvider.class);

    @Template(value="current time as a nice string")
    public static String getCurrentTime() {
        return "" + new Date(TimeProvider.getCurrentTimeInMillis());
    }

    public static MiniDateTime getCurrentTimeAsDateTime() {
        long time = TimeProvider.getCurrentTimeInMillis();
        MiniDateTime dt = new MiniDateTime(time);
        return dt;
    }

    public static long getCurrentTimeInMillis() {
        if (TimeProvider.isFakeTime()) {
            return fakeTime_;
        }
        return System.currentTimeMillis();
    }

    @Template(value="true if the time is a fake time")
    public static boolean isFakeTime() {
        return fakeTime_ > 0L;
    }

    public static void setFakeTime(long fakeTime) {
        fakeTime_ = fakeTime;
    }

    public static void setFakeTimeFromString(String fakeTimeString) {
        long fakeTime = Long.parseLong(fakeTimeString);
        TimeProvider.setFakeTime(fakeTime);
        log.warn("Set fake time to " + fakeTime);
    }
}

