/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.server.util;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.TreeMap;
import org.xydra.base.XId;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XEvent;
import org.xydra.base.change.XTransactionEvent;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.value.XValue;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.sharedutils.XyAssert;

public class XydraHtmlUtils {
    public static void writeEvents(List<XEvent> events, Writer w) throws IOException {
        XyAssert.xyAssert((events != null ? 1 : 0) != 0);
        assert (events != null);
        w.write("<table border='1'><tr><th>rev</th><th>target</th><th>type</th><th>what</th><th>oldRevs</th><th>txn</th><th>implied</th></tr>");
        for (XEvent e : events) {
            XydraHtmlUtils.writeEventRow(e, w);
            w.flush();
            if (e.getChangeType() != ChangeType.TRANSACTION) continue;
            assert (e instanceof XTransactionEvent);
            XTransactionEvent te = (XTransactionEvent)e;
            for (XEvent child : te) {
                XydraHtmlUtils.writeEventRow(child, w);
                w.flush();
            }
        }
        w.write("</table>");
    }

    private static void writeEventRow(XEvent e, Writer w) throws IOException {
        w.write("<tr><td>" + e.getRevisionNumber() + "</td>" + "<td>" + e.getTarget() + "</td> " + "<td>" + e.getChangeType() + "</td>" + "<td>" + e.getChangedEntity() + "</td>" + "<td>" + e.getOldModelRevision() + "/" + e.getOldObjectRevision() + "/" + e.getOldFieldRevision() + "</td>" + "<td>" + e.inTransaction() + "</td>" + "<td>" + e.isImplied() + "</td>" + "</tr>\n");
    }

    public static String toHtml(XReadableObject xo) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>Object '");
        buf.append(xo.getAddress());
        buf.append("' <span class='rev'>");
        buf.append(xo.getRevisionNumber());
        buf.append("</span></b>\n");
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (XId fieldId : xo) {
            XReadableField field = xo.getField(fieldId);
            assert (field != null);
            XValue value = field.getValue();
            map.put(fieldId.toString(), (value == null ? "null" : SharedHtmlUtils.sanitize((String)value.toString())) + " <span class='rev'>" + field.getRevisionNumber() + "</span>");
        }
        return buf + SharedHtmlUtils.toDefinitionList(map);
    }
}

