/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.handler;

import com.google.common.collect.Lists;
import de.xam.datafiles.handler.IDataFileHandler;
import de.xam.datafiles.store.DataMapStoreTools;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.store.MemoryDataMapStore;
import de.xam.datafiles.store.PropertiesDataMapStore;
import de.xam.datafiles.util.JavaProperties;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractPropertiesDataFileHandler
implements IDataFileHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertiesDataFileHandler.class);
    private final FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(AbstractPropertiesDataFileHandler.this.getExtension());
        }
    };

    @Override
    public abstract String getExtension();

    @Override
    public IDataMapStore read(File f) throws IOException {
        Properties props = this.loadFromFile(f);
        PropertiesDataMapStore pStore = new PropertiesDataMapStore(props);
        MemoryDataMapStore dataMapStore = new MemoryDataMapStore();
        for (String key : pStore.getKeys()) {
            Object valueObject = pStore.getValue(key);
            dataMapStore.setValue(key, valueObject);
        }
        log.trace("Read " + props.size() + " entries from " + f.getAbsolutePath() + "\n  map.keys=" + dataMapStore.getKeys());
        dataMapStore.setValue("_sourcesList", Lists.newArrayList((Object[])new String[]{f.getAbsolutePath()}));
        return dataMapStore;
    }

    private Properties loadFromFile(File f) throws IOException {
        Properties props = new Properties();
        FileInputStream in = FileUtils.openInputStream((File)f);
        this.load(props, in);
        ((InputStream)in).close();
        return props;
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public void write(IDataMapStore dataMapStore, File f) throws IOException {
        Properties existingProperties;
        Properties javaUtilProperties = new Properties();
        PropertiesDataMapStore propertiesDataMapStore = new PropertiesDataMapStore(javaUtilProperties);
        DataMapStoreTools.copy(dataMapStore, propertiesDataMapStore);
        if (f.exists() && JavaProperties.equals(existingProperties = this.loadFromFile(f), javaUtilProperties)) {
            log.debug("Avoid writing unchanged properties to " + f.getAbsolutePath());
            return;
        }
        FileOutputStream out = FileUtils.openOutputStream((File)f);
        this.store(javaUtilProperties, out);
        ((OutputStream)out).close();
    }

    protected abstract void load(Properties var1, InputStream var2) throws IOException;

    protected abstract void store(Properties var1, OutputStream var2) throws IOException;
}

