/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.store;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Lists;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.util.DataFiles;
import de.xam.datafiles.util.StringCodec;
import de.xam.datafiles.util.TypeException;
import de.xam.texthtml.text.TextTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DataMapStoreTools {
    private static final Logger log = LoggerFactory.getLogger(DataMapStoreTools.class);

    public static String interpolate_OLD(String raw, IDataMapStore dataMap) {
        if (raw == null) {
            return null;
        }
        String done = raw;
        Matcher m = TextTool.REGEX_VAR_PATTERN.matcher(done);
        int replacedVariables = 0;
        while (m.matches()) {
            String var = m.group(1);
            String varName = var.substring(2, var.length() - 1);
            Object vo = dataMap.getValue(varName);
            if (vo == null) {
                log.warn("Could not interpolate '" + var + "'");
                break;
            }
            String replacement = StringCodec.toReplacementStringFromObject(vo);
            log.trace("Replacing '" + varName + "' with '" + replacement + "'");
            done = done.replace(var, replacement);
            m = TextTool.REGEX_VAR_PATTERN.matcher(done);
            ++replacedVariables;
        }
        log.debug("Replaced " + replacedVariables);
        return done;
    }

    public static String interpolate(String raw, final IDataMapStore dataMap) {
        return TextTool.interpolate((String)raw, (TextTool.IReplacements)new TextTool.IReplacements(){

            public String getReplacement(String varName) {
                Object vo = dataMap.getValue(varName);
                if (vo == null) {
                    log.warn("Could not interpolate " + varName);
                    return null;
                }
                String replacement = StringCodec.toReplacementStringFromObject(vo);
                return replacement;
            }
        });
    }

    public static String searchAndReplace(String raw, IDataMapStore dataMap) throws TypeException {
        if (raw == null) {
            return null;
        }
        String s = raw;
        for (String key : dataMap.getKeys()) {
            if (!key.startsWith("replace-")) continue;
            String search = key.substring("replace-".length());
            Object rep = dataMap.getValue(key);
            DataMapStoreTools.ensureTypeOfObject(rep, String.class);
            String replacement = (String)rep;
            replacement = DataMapStoreTools.interpolate(replacement, dataMap);
            s = s.replace(search, replacement);
        }
        return s;
    }

    public static String dump(IDataMapStore dataMapStore) {
        if (dataMapStore.getKeys().isEmpty()) {
            return "DataMap is empty.";
        }
        StringBuilder sb = new StringBuilder("\n----");
        ArrayList keys = Lists.newArrayList(dataMapStore.getKeys());
        Collections.sort(keys);
        for (String key : keys) {
            Object value = dataMapStore.getValue(key);
            sb.append("# Type: " + (Object)((Object)DataFiles.getValueType(value)) + "\n");
            sb.append(key + "=" + StringCodec.toValueStringFromObject(value) + "\n");
        }
        sb.append("----");
        return sb.toString();
    }

    public static void merge(IDataMapStore generic, IDataMapStore specific) throws TypeException {
        for (String key : specific.getKeys()) {
            Object specificValue = specific.getValue(key);
            if (specificValue == null) continue;
            Object genericValue = generic.getValue(key);
            if (genericValue != null) {
                switch (DataFiles.getValueType(genericValue)) {
                    case Boolean: {
                        generic.setValue(key, DataMapStoreTools.mergeBoolean((Boolean)genericValue, specificValue));
                        break;
                    }
                    case Long: {
                        generic.setValue(key, DataMapStoreTools.mergeLong((Long)genericValue, specificValue));
                        break;
                    }
                    case String: {
                        generic.setValue(key, DataMapStoreTools.mergeString((String)genericValue, specificValue));
                        break;
                    }
                    case StringSet: {
                        generic.setValue(key, DataMapStoreTools.mergeStringSet((Set)genericValue, specificValue));
                        break;
                    }
                    case StringList: {
                        generic.setValue(key, DataMapStoreTools.mergeStringList((List)genericValue, specificValue));
                        break;
                    }
                    case StringMap: {
                        generic.setValue(key, DataMapStoreTools.mergeStringMap((Map)genericValue, specificValue));
                    }
                }
                continue;
            }
            generic.setValue(key, specific.getValue(key));
        }
    }

    private static Boolean mergeBoolean(Boolean genericValue, Object specificValue) throws TypeException {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, Boolean.class);
        return genericValue != false || (Boolean)specificValue != false;
    }

    private static Long mergeLong(Long genericValue, Object specificValue) throws TypeException {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, Long.class);
        return (Long)specificValue;
    }

    private static String mergeString(String genericValue, Object specificValue) {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, String.class);
        return (String)specificValue;
    }

    private static void ensureTypeOfObject(Object o, Class<?> clazz) {
        if (!clazz.isInstance(o)) {
            throw new TypeException("Require " + clazz.getName() + ", got " + o.getClass().getName());
        }
    }

    private static Map<String, String> mergeStringMap(Map<String, String> genericValue, Object specificValue) {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, Map.class);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.putAll(genericValue);
        for (Map.Entry e : ((Map)specificValue).entrySet()) {
            result.put((String)e.getKey(), (String)e.getValue());
        }
        return result;
    }

    private static List<String> mergeStringList(List<String> genericValue, Object specificValue) {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, List.class);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(genericValue);
        result.addAll((List)specificValue);
        return result;
    }

    private static Set<String> mergeStringSet(Set<String> genericValue, Object specificValue) {
        if (specificValue == null) {
            return genericValue;
        }
        DataMapStoreTools.ensureTypeOfObject(specificValue, Set.class);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(genericValue);
        result.addAll((Set)specificValue);
        return result;
    }

    public static void copy(IDataMapStore source, IDataMapStore target) {
        for (String key : source.getKeys()) {
            Object sourceValue = source.getValue(key);
            target.setValue(key, sourceValue);
        }
    }
}

