/*
 * Decompiled with CFR 0.152.
 */
package de.xam.datafiles.store;

import de.xam.datafiles.store.AbstractDataMapStore;
import de.xam.datafiles.store.IDataMapStore;
import de.xam.datafiles.util.DataFiles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;

public class PropertiesDataMapStore
extends AbstractDataMapStore
implements IDataMapStore {
    private final Properties props;

    public PropertiesDataMapStore(Properties props) {
        this.props = props;
    }

    private String getValueString(String key) {
        return (String)this.props.get(key);
    }

    private void setValueString(String key, String value) {
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.put(key, value);
        }
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Object o : this.props.keySet()) {
            keys.add((String)o);
        }
        return keys;
    }

    @Override
    public Object getValue(String key) {
        return DataFiles.valueStringToObject(this.getValueString(key));
    }

    @Override
    public void setValue(String key, Object value) {
        StringBuilder b = DataFiles.valueObjectToString(value);
        this.setValueString(key, b == null ? null : b.toString());
    }
}

