/*
 * Decompiled with CFR 0.152.
 */
package de.xam.vocabulary;

import de.xam.vocabulary.Vocabulary;
import java.util.Iterator;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Vocabularies {
    private static final IMapSetIndex<String, Vocabulary> MAP = MapSetIndex.createWithSmallEntrySets();
    private static final Logger log = LoggerFactory.getLogger(Vocabularies.class);

    public static XId addModifier(XId id, String modifier) {
        return Base.toId((String)(id.toString() + "-" + modifier));
    }

    public static boolean containsModifier(XId id, String modifier) {
        return id.toString().endsWith("-" + modifier);
    }

    public static synchronized Vocabulary create(String namespace, Class<?> vocabularyConstantsClass) {
        Vocabulary voc = Vocabularies.createUnindexed(namespace, vocabularyConstantsClass);
        String indexKey = Vocabularies.toIndexKey(namespace);
        if (indexKey.equals(namespace) && MAP.containsKey((Object)indexKey)) {
            log.warn("namespace '" + namespace + "' defined twice?");
        }
        MAP.index((Object)indexKey, (Object)voc);
        return voc;
    }

    public static synchronized Vocabulary createUnindexed(String namespace, Class<?> vocabularyConstantsClass) {
        Vocabulary voc = new Vocabulary(namespace);
        voc.setConstantsClass(vocabularyConstantsClass);
        return voc;
    }

    public static synchronized void dumpAll() {
        Iterator it = MAP.tupleIterator((Constraint)new Wildcard(), (Constraint)new Wildcard());
        while (it.hasNext()) {
            KeyEntryTuple ket = (KeyEntryTuple)it.next();
            String ns = (String)ket.getKey();
            log.info("===== Namespace '" + ns + "'");
            IEntrySet vocs = MAP.lookup((Object)ns);
            for (Vocabulary voc : vocs.toSet()) {
                log.info("===== Vocab");
                voc.dump();
            }
        }
    }

    public static String getLocalname(XId id) {
        String s = id.toString();
        int i = s.indexOf("-");
        if (i <= 0) {
            return s;
        }
        assert (i > 0);
        i = s.indexOf("-", i + 1);
        assert (i > 0);
        return s.substring(i + 1);
    }

    public static synchronized IEntrySet<Vocabulary> getVocabulariesByNamespace(String namespace) {
        return MAP.lookup((Object)Vocabularies.toIndexKey(namespace));
    }

    public static synchronized Vocabulary getVocabularyByNamespace(String namespace) throws IllegalStateException {
        IEntrySet set = MAP.lookup((Object)Vocabularies.toIndexKey(namespace));
        if (set == null) {
            throw new IllegalStateException("Found no vocabulary with namespace '" + namespace + "'");
        }
        if (set.size() > 1) {
            throw new IllegalStateException("Found multiple vocabularies with namespace '" + namespace + "'");
        }
        return (Vocabulary)set.iterator().next();
    }

    public static Iterator<Vocabulary> iterator() {
        return MAP.constraintIterator((Constraint)new Wildcard());
    }

    private static String toIndexKey(String namespace) {
        return namespace == null ? "__default" : namespace;
    }
}

