/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.util.Date;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.util.ComparisonStrategy;
import org.fest.util.Dates;
import org.fest.util.StandardComparisonStrategy;

public class ShouldBeAfter
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeAfter(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeAfter(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeAfter(Date actual, Date other) {
        return new ShouldBeAfter(actual, other, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeAfter(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = Dates.parse((String)(year + "-01-01"));
        return new ShouldBeAfter(actual, januaryTheFirstOfGivenYear, (ComparisonStrategy)StandardComparisonStrategy.instance());
    }

    private ShouldBeAfter(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        super("expected:<%s> to be strictly after:<%s>%s", actual, other, comparisonStrategy);
    }
}

