/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.jetty;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.xydra.jetty.EmbeddedJetty;
import org.xydra.jetty.JettyUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DesktopJetty
extends EmbeddedJetty {
    private static Logger log = LoggerFactory.getLogger(DesktopJetty.class);
    private final Filter noCachingFilter = JettyUtils.createNoCacheFilter();

    @Override
    protected void configureWebapp(WebAppContext webapp) {
        log.info("Configuring DesktopJetty");
        FilterHolder cacheNothingFilterHolder = new FilterHolder();
        cacheNothingFilterHolder.setFilter(this.noCachingFilter);
        webapp.addFilter(cacheNothingFilterHolder, "*.*", EnumSet.allOf(DispatcherType.class));
        FilterHolder noCacheFilterHolder = new FilterHolder();
        noCacheFilterHolder.setFilter(this.noCachingFilter);
        webapp.addFilter(noCacheFilterHolder, "*.nocache.*", EnumSet.allOf(DispatcherType.class));
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("ico", "image/x-icon");
        mimeTypes.addMimeMapping("svg", "image/svg+xml");
        mimeTypes.addMimeMapping("woff", "application/x-font-woff");
        mimeTypes.addMimeMapping("eot", "application/vnd.ms-fontobject");
        mimeTypes.addMimeMapping("otf", "font/opentype");
        mimeTypes.addMimeMapping("css", "text/css");
        mimeTypes.addMimeMapping("webapp", "application/x-web-app-manifest+json");
        mimeTypes.addMimeMapping("appcache", "text/cache-manifest");
        mimeTypes.addMimeMapping("manifest", "text/cache-manifest");
        webapp.setMimeTypes(mimeTypes);
        webapp.getSecurityHandler().setLoginService(JettyUtils.createInsecureTestLoginService());
    }
}

