/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.googlecode.gwt.test.GwtTestWithMocks;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.exceptions.ReflectionException;
import com.googlecode.gwt.test.internal.BrowserSimulatorImpl;
import com.googlecode.gwt.test.internal.GwtFactory;
import com.googlecode.gwt.test.internal.utils.ArrayUtils;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GwtTestWithEasyMock
extends GwtTestWithMocks {
    @Before
    public void beforeGwtTestWithEasyMock() {
        Object mock;
        for (Class clazz : this.mockedClasses) {
            mock = this.createMock(clazz);
            this.addMockedObject(clazz, mock);
        }
        try {
            for (Field f : this.mockFields) {
                mock = this.mockObjects.get(f.getType());
                GwtReflectionUtils.makeAccessible(f);
                f.set(this, mock);
            }
        }
        catch (Exception e) {
            if (GwtTestException.class.isInstance(e)) {
                throw (GwtTestException)e;
            }
            throw new ReflectionException("Error during gwt-test-utils @Mock creation", e);
        }
    }

    protected <T> T createMockAndKeepMethods(Class<T> clazz, final boolean keepSetters, final Method ... list) {
        final ArrayList l = new ArrayList();
        GwtReflectionUtils.doWithMethods(clazz, new GwtReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                if (!(ArrayUtils.contains(list, method) || keepSetters && method.getName().startsWith("set") && method.getReturnType() == Void.TYPE)) {
                    l.add(method);
                }
            }
        });
        Object o = EasyMock.createMockBuilder(clazz).addMockedMethods(l.toArray(new Method[0])).createMock();
        this.addMockedObject(clazz, o);
        return (T)o;
    }

    protected <T> T createMockAndKeepOneMethod(Class<T> clazz, String methodName, Class<?> ... paramsTypes) {
        return this.createMockAndKeepMethods(clazz, true, GwtReflectionUtils.findMethod(clazz, methodName, paramsTypes));
    }

    protected <T extends Throwable> IExpectationSetters<T> expectServiceAndCallbackOnFailure(T exception) {
        FailureAnswer<T> answer = new FailureAnswer<T>(exception);
        IExpectationSetters o = EasyMock.expectLastCall().andAnswer(answer);
        return o;
    }

    protected <T> IExpectationSetters<T> expectServiceAndCallbackOnSuccess(T object) {
        SuccessAnswer<T> answer = new SuccessAnswer<T>(object);
        return EasyMock.expectLastCall().andAnswer(answer);
    }

    protected void replay() {
        for (Object o : this.mockObjects.values()) {
            EasyMock.replay((Object[])new Object[]{o});
        }
    }

    protected void reset() {
        for (Object o : this.mockObjects.values()) {
            EasyMock.reset((Object[])new Object[]{o});
        }
    }

    protected void verify() {
        BrowserSimulatorImpl.get().fireLoopEnd();
        for (Object o : this.mockObjects.values()) {
            EasyMock.verify((Object[])new Object[]{o});
        }
    }

    private Object createMock(Class<?> clazz) {
        if (GwtFactory.get().getOverlayRewriter().isJsoIntf(clazz.getName())) {
            try {
                return EasyMock.createMock(Class.forName("com.google.gwt.core.client.JavaScriptObject$"));
            }
            catch (ClassNotFoundException e) {
                throw new GwtTestPatchException("Error while creating a mock with EasyMock for " + clazz.getName(), e);
            }
        }
        return EasyMock.createMock(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuccessAnswer<T>
    implements IAnswer<T> {
        private final T result;

        public SuccessAnswer(T result) {
            this.result = result;
        }

        public T answer() throws Throwable {
            Object[] arguments = EasyMock.getCurrentArguments();
            AsyncCallback callback = (AsyncCallback)arguments[arguments.length - 1];
            callback.onSuccess(this.result);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailureAnswer<T extends Throwable>
    implements IAnswer<T> {
        private final T result;

        public FailureAnswer(T result) {
            this.result = result;
        }

        public T answer() throws Throwable {
            Object[] arguments = EasyMock.getCurrentArguments();
            AsyncCallback callback = (AsyncCallback)arguments[arguments.length - 1];
            callback.onFailure(this.result);
            return null;
        }
    }
}

