/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.Patcher;
import com.googlecode.gwt.test.utils.JavaScriptObjects;
import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

class OverlayPatcher
implements Patcher {
    private static CtClass STRING_TYPE;
    private final Patcher decoratedPatcher;

    OverlayPatcher(Patcher patcher) {
        this.decoratedPatcher = patcher;
    }

    public void finalizeClass(CtClass c) throws Exception {
        if (this.decoratedPatcher != null) {
            this.decoratedPatcher.finalizeClass(c);
        }
    }

    public String getNewBody(CtMethod m) throws Exception {
        String newBody;
        String string = newBody = this.decoratedPatcher != null ? this.decoratedPatcher.getNewBody(m) : null;
        if (newBody != null || !Modifier.isNative(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) {
            return newBody;
        }
        String propertyName = this.getPropertyName(m);
        if (propertyName == null) {
            return null;
        }
        if (m.getName().startsWith("set") && m.getReturnType() == CtClass.voidType) {
            return this.getCodeSetProperty("this", propertyName, "$1");
        }
        return "return " + this.getCodeGetProperty("this", propertyName, m.getReturnType());
    }

    public void initClass(CtClass c) throws Exception {
        if (this.decoratedPatcher != null) {
            this.decoratedPatcher.initClass(c);
        }
    }

    private String getCodeGetProperty(String object, String fieldName, CtClass returnType) {
        if (returnType == STRING_TYPE) {
            return JavaScriptObjects.class.getName() + ".getString(" + object + ", \"" + fieldName + "\")";
        }
        if (returnType == CtClass.booleanType) {
            return JavaScriptObjects.class.getName() + ".getBoolean(" + object + ", \"" + fieldName + "\")";
        }
        if (returnType == CtClass.intType) {
            return JavaScriptObjects.class.getName() + ".getInteger(" + object + ", \"" + fieldName + "\")";
        }
        if (returnType == CtClass.doubleType) {
            return JavaScriptObjects.class.getName() + ".getDouble(" + object + ", \"" + fieldName + "\")";
        }
        if (returnType == CtClass.floatType) {
            return JavaScriptObjects.class.getName() + ".getFloat(" + object + ", \"" + fieldName + "\")";
        }
        if (returnType == CtClass.shortType) {
            return JavaScriptObjects.class.getName() + ".getShort(" + object + ", \"" + fieldName + "\")";
        }
        return "(" + returnType.getName() + ") " + JavaScriptObjects.class.getName() + ".getObject(" + object + ", \"" + fieldName + "\")";
    }

    private String getCodeSetProperty(String object, String propertyName, String propertyValue) {
        return JavaScriptObjects.class.getName() + ".setProperty(" + object + ", \"" + propertyName + "\", " + propertyValue + ")";
    }

    private String getPropertyName(CtMethod m) throws Exception {
        String fieldName = null;
        String name = m.getName();
        if (!CtClass.voidType.equals(m.getReturnType()) && m.getParameterTypes().length == 0) {
            fieldName = name.startsWith("get") ? Character.toLowerCase(name.charAt(3)) + name.substring(4) : (m.getName().startsWith("is") ? Character.toLowerCase(name.charAt(2)) + name.substring(3) : name);
        } else if (name.startsWith("set") && m.getParameterTypes().length == 1) {
            fieldName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return fieldName;
    }

    static {
        try {
            STRING_TYPE = GwtClassPool.get().get(String.class.getName());
        }
        catch (NotFoundException e) {
            throw new GwtTestPatchException(e);
        }
    }
}

