/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.googlecode.gwt.test.exceptions.GwtTestRpcException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import com.googlecode.gwt.test.internal.JavaClassModifier;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableModifier
implements JavaClassModifier {
    private static final String DEFAULT_CONS_METHOD_NAME = "DEFAULT_CONS_METHOD";
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializableModifier.class);
    private final CtClass charSequenceCtClass;
    private final CtClass externalizableCtClass;
    private final CtClass isSerializableCtClass;
    private final CtClass serializableCtClass = GwtClassPool.getCtClass(Serializable.class);

    public static void readObject(Serializable ex, ObjectInputStream ois) {
        try {
            ois.defaultReadObject();
            Map<Field, Object> buffer = SerializableModifier.getFieldValues(ex);
            GwtReflectionUtils.callPrivateMethod((Object)ex, DEFAULT_CONS_METHOD_NAME, new Object[0]);
            for (Map.Entry<Field, Object> entry : buffer.entrySet()) {
                entry.getKey().set(ex, entry.getValue());
            }
        }
        catch (Exception e) {
            throw new GwtTestRpcException("Error during deserialization of object " + ex.getClass().getName(), e);
        }
    }

    private static Map<Field, Object> getFieldValues(Serializable o) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Field, Object> result = new HashMap<Field, Object>();
        for (Field field : GwtReflectionUtils.getFields(o.getClass())) {
            int fieldModifier = field.getModifiers();
            if (Modifier.isStatic((int)fieldModifier) || Modifier.isTransient((int)fieldModifier)) continue;
            result.put(field, field.get(o));
        }
        return result;
    }

    public SerializableModifier() {
        this.isSerializableCtClass = GwtClassPool.getCtClass(IsSerializable.class);
        this.externalizableCtClass = GwtClassPool.getCtClass(Externalizable.class);
        this.charSequenceCtClass = GwtClassPool.getCtClass(CharSequence.class);
    }

    @Override
    public void modify(CtClass classToModify) throws Exception {
        if (classToModify.isInterface() || classToModify.isPrimitive() || classToModify.isEnum() || classToModify.isArray() || classToModify.isAnnotation() || Modifier.isAbstract((int)classToModify.getModifiers())) {
            return;
        }
        if (classToModify.subtypeOf(this.charSequenceCtClass)) {
            return;
        }
        if (classToModify.subtypeOf(this.externalizableCtClass)) {
            return;
        }
        if (classToModify.subtypeOf(this.isSerializableCtClass) && !classToModify.subtypeOf(this.serializableCtClass)) {
            CtClass[] interfaces = classToModify.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!this.isSerializableCtClass.equals(interfaces[i])) continue;
                interfaces[i] = this.serializableCtClass;
            }
            classToModify.setInterfaces(interfaces);
        }
        if (!classToModify.subtypeOf(this.serializableCtClass)) {
            return;
        }
        if (this.getReadObjectMethod(classToModify) != null) {
            return;
        }
        CtConstructor defaultCons = this.getDefaultConstructor(classToModify);
        if (defaultCons == null) {
            return;
        }
        LOGGER.debug("Apply serializable bytecode modifier");
        CtMethod defaultConstMethod = defaultCons.toMethod(DEFAULT_CONS_METHOD_NAME, classToModify);
        defaultConstMethod.setModifiers(1);
        if (this.hasDefaultConstMethod(classToModify.getSuperclass())) {
            defaultConstMethod.insertBefore("super.DEFAULT_CONS_METHOD();");
        }
        classToModify.addMethod(defaultConstMethod);
        this.overrideReadObject(classToModify);
    }

    private String callStaticReadObject() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        buffer.append(this.getClass().getName() + ".readObject(");
        buffer.append("(").append(Serializable.class.getName()).append(")");
        buffer.append(" this, $1);}");
        return buffer.toString();
    }

    private CtConstructor getDefaultConstructor(CtClass ctClass) {
        try {
            return ctClass.getConstructor(Descriptor.ofConstructor((CtClass[])new CtClass[0]));
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private CtMethod getReadObjectMethod(CtClass ctClass) {
        CtClass[] paramTypes = new CtClass[]{GwtClassPool.getCtClass(ObjectInputStream.class)};
        try {
            return ctClass.getDeclaredMethod("readObject", paramTypes);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    private boolean hasDefaultConstMethod(CtClass ctClass) {
        try {
            CtMethod m = ctClass.getMethod(DEFAULT_CONS_METHOD_NAME, Descriptor.ofMethod((CtClass)CtClass.voidType, (CtClass[])new CtClass[0]));
            return m != null;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private void overrideReadObject(CtClass classToModify) throws NotFoundException, CannotCompileException {
        CtClass[] paramTypes = new CtClass[]{GwtClassPool.getCtClass(ObjectInputStream.class)};
        CtMethod readObjectMethod = new CtMethod(CtClass.voidType, "readObject", paramTypes, classToModify);
        readObjectMethod.setModifiers(2);
        CtClass classNotFoundException = GwtClassPool.getCtClass(ClassNotFoundException.class);
        CtClass ioException = GwtClassPool.getCtClass(IOException.class);
        readObjectMethod.setExceptionTypes(new CtClass[]{classNotFoundException, ioException});
        readObjectMethod.setBody(this.callStaticReadObject());
        classToModify.addMethod(readObjectMethod);
    }
}

